% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_info.R
\name{standardize_info}
\alias{standardize_info}
\title{Get Standardization Information}
\usage{
standardize_info(
  model,
  robust = FALSE,
  two_sd = FALSE,
  include_pseudo = FALSE,
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{robust}{Logical, if \code{TRUE}, centering is done by subtracting the
median from the variables and dividing it by the median absolute deviation
(MAD). If \code{FALSE}, variables are standardized by subtracting the
mean and dividing it by the standard deviation (SD).}

\item{two_sd}{If \code{TRUE}, the variables are scaled by two times the deviation
(SD or MAD depending on \code{robust}). This method can be useful to obtain
model coefficients of continuous parameters comparable to coefficients
related to binary predictors, when applied to \strong{the predictors} (not the
outcome) (Gelman, 2008).}

\item{include_pseudo}{(For (G)LMMs) Should Pseudo-standardized information be
included?}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame with information on each parameter (see
\link[parameters:parameters_type]{parameters::parameters_type}), and various standardization coefficients
for the post-hoc methods (see \code{\link[=standardize_parameters]{standardize_parameters()}}) for the predictor
and the response.
}
\description{
This function extracts information, such as the deviations (SD or MAD) from
parent variables, that are necessary for post-hoc standardization of
parameters. This function gives a window on how standardized are obtained,
i.e., by what they are divided. The "basic" method of standardization uses.
}
\examples{
model <- lm(mpg ~ ., data = mtcars)
standardize_info(model)
standardize_info(model, robust = TRUE)
standardize_info(model, two_sd = TRUE)
}
\seealso{
Other standardize: 
\code{\link{standardize_parameters}()},
\code{\link{standardize}()}
}
\concept{standardize}
