% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_diff.R
\name{rank_biserial}
\alias{rank_biserial}
\alias{cliffs_delta}
\title{Dominance Effect Sizes for Rank Based Differences}
\usage{
rank_biserial(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  paired = FALSE,
  ci = 0.95,
  alternative = "two.sided",
  verbose = TRUE,
  ...
)

cliffs_delta(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  ci = 0.95,
  alternative = "two.sided",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x, y}{A numeric or ordered vector, or a character name of one in \code{data}.
Any missing values (\code{NA}s) are dropped from the resulting vector. \code{x} can
also be a formula (see \code{\link[stats:wilcox.test]{stats::wilcox.test()}}), in which case \code{y} is
ignored.}

\item{data}{An optional data frame containing the variables.}

\item{mu}{a number indicating the value around which (a-)symmetry (for
one-sample or paired samples) or shift (for independent samples) is to be
estimated. See \link[stats:wilcox.test]{stats::wilcox.test}.}

\item{paired}{If \code{TRUE}, the values of \code{x} and \code{y} are considered as paired.
This produces an effect size that is equivalent to the one-sample effect
size on \code{x - y}.}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (default, two-sided CI),
\code{"greater"} or \code{"less"} (one-sided CI). Partial matching is allowed (e.g.,
\code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in \link{effectsize_CIs}.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{...}{Arguments passed to or from other methods. When \code{x} is a formula,
these can be \code{subset} and \code{na.action}.}
}
\value{
A data frame with the effect size \code{r_rank_biserial} and its CI
(\code{CI_low} and \code{CI_high}).
}
\description{
Compute the rank-biserial correlation (\eqn{r_{rb}}{r_rb}) and Cliff's \emph{delta}
(\eqn{\delta}) effect sizes for non-parametric
(rank sum) differences. These effect sizes of dominance are closely related
to the \link[=cohens_u3]{Common Language Effect Sizes}. Pair with any reported
\code{\link[stats:wilcox.test]{stats::wilcox.test()}}.
}
\details{
The rank-biserial correlation is appropriate for non-parametric tests of
differences - both for the one sample or paired samples case, that would
normally be tested with Wilcoxon's Signed Rank Test (giving the
\strong{matched-pairs} rank-biserial correlation) and for two independent samples
case, that would normally be tested with Mann-Whitney's \emph{U} Test (giving
\strong{Glass'} rank-biserial correlation). See \link[stats:wilcox.test]{stats::wilcox.test}. In both
cases, the correlation represents the difference between the proportion of
favorable and unfavorable pairs / signed ranks (Kerby, 2014). Values range
from \code{-1} complete dominance of the second sample (\emph{all} values of the second
sample are larger than \emph{all} the values of the first sample) to \code{+1} complete
dominance of the fist sample (\emph{all} values of the second sample are smaller
than \emph{all} the values of the first sample).
\cr\cr
Cliff's \emph{delta} is an alias to the rank-biserial correlation in the two sample case.
}
\section{Ties}{
When tied values occur, they are each given the average of the ranks that
would have been given had no ties occurred. This results in an effect size of
reduced magnitude. A correction has been applied for Kendall's \emph{W}.
}

\section{Confidence (Compatibility) Intervals (CIs)}{
Confidence intervals for the rank-biserial correlation (and Cliff's \emph{delta})
are estimated using the normal approximation (via Fisher's transformation).
}

\section{CIs and Significance Tests}{
"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\section{Plotting with \code{see}}{

The \code{see} package contains relevant plotting functions. See the \href{https://easystats.github.io/see/articles/effectsize.html}{plotting vignette in the \code{see} package}.
}

\examples{
\donttest{
data(mtcars)
mtcars$am <- factor(mtcars$am)
mtcars$cyl <- factor(mtcars$cyl)

# Two Independent Samples ----------
(rb <- rank_biserial(mpg ~ am, data = mtcars))
# Same as:
# rank_biserial("mpg", "am", data = mtcars)
# rank_biserial(mtcars$mpg[mtcars$am=="0"], mtcars$mpg[mtcars$am=="1"])
# cliffs_delta(mpg ~ am, data = mtcars)

# More options:
rank_biserial(mpg ~ am, data = mtcars, mu = -5)
print(rb, append_CLES = TRUE)


# One Sample ----------
# from help("wilcox.test")
x <- c(1.83, 0.50, 1.62, 2.48, 1.68, 1.88, 1.55, 3.06, 1.30)
y <- c(0.878, 0.647, 0.598, 2.05, 1.06, 1.29, 1.06, 3.14, 1.29)
depression <- data.frame(first = x, second = y, change = y - x)

rank_biserial(change ~ 1, data = depression)

# same as:
# rank_biserial("change", data = depression)
# rank_biserial(mtcars$wt)

# More options:
rank_biserial(change ~ 1, data = depression, mu = -0.5)


# Paired Samples ----------
(rb <- rank_biserial(Pair(first, second) ~ 1, data = depression))

# same as:
# rank_biserial(depression$first, depression$second, paired = TRUE)

interpret_rank_biserial(0.78)
interpret(rb, rules = "funder2019")
}

}
\references{
\itemize{
\item Cureton, E. E. (1956). Rank-biserial correlation. Psychometrika, 21(3),
287-290.
\item Glass, G. V. (1965). A ranking variable analogue of biserial correlation:
Implications for short-cut item analysis. Journal of Educational Measurement,
2(1), 91-95.
\item Kerby, D. S. (2014). The simple difference formula: An approach to teaching
nonparametric correlation. Comprehensive Psychology, 3, 11-IT.
\item King, B. M., & Minium, E. W. (2008). Statistical reasoning in the
behavioral sciences. John Wiley & Sons Inc.
\item Cliff, N. (1993). Dominance statistics: Ordinal analyses to answer ordinal
questions. Psychological bulletin, 114(3), 494.
\item Tomczak, M., & Tomczak, E. (2014). The need to report effect size estimates
revisited. An overview of some recommended measures of effect size.
}
}
\seealso{
Other standardized differences: 
\code{\link{cohens_d}()},
\code{\link{mahalanobis_d}()},
\code{\link{means_ratio}()},
\code{\link{p_superiority}()},
\code{\link{repeated_measures_d}()}

Other rank-based effect sizes: 
\code{\link{p_superiority}()},
\code{\link{rank_epsilon_squared}()}
}
\concept{effect size indices}
\concept{rank-based effect sizes}
\concept{standardized differences}
