% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vert.attr.R
\name{vert.attr}
\alias{vert.attr}
\title{Vertex attribute to data frame into graph.}
\usage{
vert.attr(data, attribute, graph, dataID, graphID = "name", FUN = NA,
  unfactor = TRUE)
}
\arguments{
\item{data}{Data frame. The data.frame containing the author attribute
variable to be imported in the graph (it must also include a authorID
variable).}

\item{attribute}{A variable name in 'data' (as character)}

\item{graph}{Researchers graph where to import the attribute.}

\item{dataID}{Character. The variable in data giving the ID of nodes in the
graph (authors)}

\item{graphID}{Character. The vertex attribute of graph that gives node IDs
(i.e. IDs of authors) which are the same as dataID.}

\item{FUN}{A function name given as character. The argument is ignored if
"data" has one record for each dataID value, i.e. does not need aggregation
by dataID. If NA or missing, attribute is aggregated by just taking its 1st
non-NA value for each value of dataID.}

\item{unfactor}{Logical. If TRUE, and attribute is character, keeps it from
being turned into factor. Notice that this argument has no effect if the
attribute is aggregated first. \bold{TODO}: regulate this behavior when
attribute is factor (not character) in the first place; regulate this
behavior when attribute is aggregated first.}
}
\value{
A vector that contains the attribute 'attribute' from data, in the
order given by the order of authorID in the graph 'graph'.
}
\description{
Extracts a vertex variable from a data.frame and returns it as a vector ready
to be set as vertex attribute in a graph. May aggregate the variable by node
before returning. This function extracts variables at the author level from
'data' and set them as vertex.attributes in 'graph', a network of authors.
The function aggregates the variable by author using the aggregating function
FUN. The function needs a 'graph' igraph object of authors in which the UFIDs
are recorded as a  attribute, and a 'data' data.frame in which the same UFIDs
are associated to a variable (attribute). The function takes \code{data} and
aggregates FUN(attribute) by dataID in 'data'. It returns the result of the
aggregation in the order of dataID given by V(graph)$name. NOTE that if
attribute is categorical (e.g. College), the argument FUN is ignored and
vert.attr() is just going to take the category of the variable for authorID
(if there are more than 1 category, e.g. more than 1 Academic Units, for the
same authorID, vert.attr just takes the 1st category associated to authorID
in 'data').
}
\seealso{
\code{\link{vert.attr.multi}}
}
