% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surname_utils.R
\name{strip_special_characters}
\alias{strip_special_characters}
\title{Strips special characters from a voter file.}
\usage{
strip_special_characters(
  voter_file,
  surname_col = "last_name",
  regex = "[^A-Za-z]+",
  replace = " "
)
}
\arguments{
\item{voter_file}{The voter file, with each row consisting of a voter.}

\item{surname_col}{A string denoting the surname column.}

\item{regex}{A string denoting the regular expression to use for denoting the
the special characters.}

\item{replace}{The replacement string for special characters.}
}
\value{
A dataframe of voters whose surname column is stripped of special
 characters.
}
\description{
Given a voter file and a column, returns a voter file with special characters
stripped stripped from that column.
}
