% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs_mget.r
\name{docs_mget}
\alias{docs_mget}
\title{Get multiple documents via the multiple get API.}
\usage{
docs_mget(index = NULL, type = NULL, ids = NULL, type_id = NULL,
  index_type_id = NULL, source = NULL, fields = NULL, raw = FALSE,
  callopts = list(), verbose = TRUE, ...)
}
\arguments{
\item{index}{Index. Required.}

\item{type}{Document type. Required.}

\item{ids}{More than one document id, see examples.}

\item{type_id}{List of vectors of length 2, each with an element for 
type and id.}

\item{index_type_id}{List of vectors of length 3, each with an element for 
index, type, and id.}

\item{source}{(logical) If \code{TRUE}, return source.}

\item{fields}{Fields to return from the response object.}

\item{raw}{If TRUE (default), data is parsed to list. If FALSE, then raw JSON.}

\item{callopts}{Curl args passed on to httr::POST.}

\item{verbose}{If TRUE (default) the url call used printed to console.}

\item{...}{Further args passed on to elastic search HTTP API as parameters.}
}
\description{
Get multiple documents via the multiple get API.
}
\details{
You can pass in one of three combinations of parameters:
\itemize{
 \item Pass in something for \code{index}, \code{type}, and \code{id}. 
 This is the simplest, allowing retrieval from the same index, same type, 
 and many ids.
 \item Pass in only \code{index} and \code{type_id} - this allows you to 
 get multiple documents from the same index, but from different types.
 \item Pass in only \code{index_type_id} - this is so that you can get 
 multiple documents from different indexes and different types.
}
}
\examples{
\dontrun{
connect()

if (!index_exists('plos')) {
  plosdat <- system.file("examples", "plos_data.json", package = "elastic")
  invisible(docs_bulk(plosdat))
}

# Same index and type
docs_mget(index="plos", type="article", ids=c(9,10))

tmp <- docs_mget(index="plos", type="article", ids=c(9, 10), 
  raw=TRUE)
es_parse(tmp)
docs_mget(index="plos", type="article", ids=c(9, 10), 
  source='title')
docs_mget(index="plos", type="article", ids=c(14, 19), 
  source=TRUE)

# curl options
library("httr")
docs_mget(index="plos", type="article", ids=1:2, callopts=verbose())

# Same index, but different types
if (!index_exists('shakespeare')) {
  shakedat <- system.file("examples", "shakespeare_data.json", package = "elastic")
  invisible(docs_bulk(shakedat))
}

docs_mget(index="shakespeare", type_id=list(c("scene",1), c("line",20)))
docs_mget(index="shakespeare", type_id=list(c("scene",1), c("line",20)), 
  source='play_name')

# Different indices and different types pass in separately
docs_mget(index_type_id = list(
  c("shakespeare", "line", 20), 
  c("plos", "article", 1)
 )
)
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-multi-get.html}
}
