% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vote_section.R
\name{vote_section}
\alias{vote_section}
\title{Download data on candidate electoral results in federal elections in Brazil by electoral section}
\usage{
vote_section(
  year,
  uf = "AC",
  encoding = "latin1",
  temp = TRUE,
  readme_pdf = FALSE
)
}
\arguments{
\item{year}{Election year. For this function, only the years 1998, 2002, 2006, 2010, and 2014
are available.}

\item{uf}{Federation Unit acronym (\code{character vector}). Defaults to \code{'AC'} (Acre).}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). If \code{TRUE}, keep the temporary compressed file for future use (recommended)}

\item{readme_pdf}{original file}
}
\value{
\code{vote_section()} returns a \code{data.frame}.
}
\description{
\code{vote_section()} downloads and cleans data on the verification of federal elections in Brazil,
disaggregated by electoral section. Different from other electionsBR's functions, results are only extract for individual states, one at a time. The function returns a \code{data.frame} where each observation
corresponds to an electoral section in a given Brazilian state.
}
\details{
If export is set to \code{TRUE}, the data is saved as .dta and .sav
 files in the working directory.
}
\note{
For the elections prior to 2002, some information can be incomplete.
}
\examples{
\dontrun{
df <- vote_section(2002)
}
}
