% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elev_point.R
\name{get_elev_point}
\alias{get_elev_point}
\title{Get Point Elevation}
\usage{
get_elev_point(locations, prj = NULL, src = c("epqs", "aws"), ...)
}
\arguments{
\item{locations}{Either a \code{data.frame} with x (e.g. longitude) as the 
first column and y (e.g. latitude) as the second column, a 
\code{SpatialPoints}/\code{SpatialPointsDataFrame}, or a 
\code{sf} \code{POINT} or \code{MULTIPOINT} object.   
Elevation for these points will be returned in the 
originally supplied class.}

\item{prj}{A PROJ.4 string defining the projection of the locations argument. 
If a \code{SpatialPoints} or \code{SpatialPointsDataFrame} is 
provided, the PROJ.4 string will be taken from that.  This 
argument is required for a \code{data.frame} of locations.}

\item{src}{A character indicating which API to use, either "epqs" or "aws" 
accepted. The "epqs" source is relatively slow for larger numbers 
of points (e.g. > 500).  The "aws" source may be quicker in these 
cases provided the points are in a similar geographic area.  The 
"aws" source downloads a DEM using \code{get_elev_raster} and then
extracts the elevation for each point.}

\item{...}{Additional arguments passed to get_epqs or get_aws_points.  When 
using "aws" as the source, pay attention to the `z` argument.  A 
defualt of 5 is used, but this uses a raster with a large ~4-5 km 
pixel.  Additionally, the source data changes as zoom levels 
increase.  
Read \url{https://github.com/tilezen/joerd/blob/master/docs/data-sources.md#what-is-the-ground-resolution} 
for details.}
}
\value{
Function returns a \code{SpatialPointsDataFrame} or \code{sf} object 
        in the projection specified by the \code{prj} argument.
}
\description{
This function provides access to point elevations using either the USGS 
Elevation Point Query Service (US Only) or by extracting point elevations 
from the AWS Terrain Tiles.  The function accepts a \code{data.frame} of x 
(long) and y (lat) or a \code{SpatialPoints}/\code{SpatialPointsDataFame} as 
input.  A SpatialPointsDataFrame is returned with elevation as an added 
\code{data.frame}.
}
\examples{
\dontrun{
mt_wash <- data.frame(x = -71.3036, y = 44.2700)
mt_mans <- data.frame(x = -72.8145, y = 44.5438)
mts <- rbind(mt_wash,mt_mans)
ll_prj <- "EPSG:4326"
mts_sp <- sp::SpatialPoints(sp::coordinates(mts), 
                            proj4string = sp::CRS(ll_prj)) 
get_elev_point(locations = mt_wash, prj = ll_prj)
get_elev_point(locations = mt_wash, units="feet", prj = ll_prj)
get_elev_point(locations = mt_wash, units="meters", prj = ll_prj)
get_elev_point(locations = mts_sp)

# Code to split into a loop and grab point at a time.
# This is usually faster for points that are spread apart 
 
library(dplyr)

elev <- vector("numeric", length = nrow(mts))
pb <- progress_estimated(length(elev))
for(i in seq_along(mts)){
pb$tick()$print()
elev[i]<-suppressMessages(get_elev_point(locations = mts[i,], prj = ll_prj, 
                                        src = "aws", z = 14)$elevation)
                                        }
mts_elev <- cbind(mts, elev)
mts_elev
}
}
