% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider.R
\name{Provider}
\alias{Provider}
\title{A chatbot provider}
\usage{
Provider(base_url = stop("Required"), extra_args = list())
}
\arguments{
\item{base_url}{The base URL for the API.}

\item{extra_args}{Arbitrary extra arguments to be included in the request body.}
}
\value{
An S7 Provider object.
}
\description{
A Provider captures the details of one chatbot service/API. This captures
how the API works, not the details of the underlying large language model.
Different providers might offer the same (open source) model behind a
different API.
}
\details{
To add support for a new backend, you will need to subclass \code{Provider}
(adding any additional fields that your provider needs) and then implement
the various generics that control the behavior of each provider.
}
\examples{
Provider(base_url = "https://cool-models.com")
}
