% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-perplexity.R
\name{chat_perplexity}
\alias{chat_perplexity}
\title{Chat with a model hosted on perplexity.ai}
\usage{
chat_perplexity(
  system_prompt = NULL,
  turns = NULL,
  base_url = "https://api.perplexity.ai/",
  api_key = perplexity_key(),
  model = NULL,
  seed = NULL,
  api_args = list(),
  echo = NULL
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{turns}{A list of \link{Turn}s to start the chat with (i.e., continuing a
previous conversation). If not provided, the conversation begins from
scratch.}

\item{base_url}{The base URL to the endpoint; the default uses OpenAI.}

\item{api_key}{The API key to use for authentication. You generally should
not supply this directly, but instead set the \code{PERPLEXITY_API_KEY} environment
variable.}

\item{model}{The model to use for the chat. The default, \code{NULL}, will pick
a reasonable default, and tell you about. We strongly recommend explicitly
choosing a model for all but the most casual use.}

\item{seed}{Optional integer seed that ChatGPT uses to try and make output
more reproducible.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
Sign up at \url{https://www.perplexity.ai}.

Perplexity AI is a platform for running LLMs that are capable of
searching the web in real-time to help them answer questions with
information that may not have been available when the model was
trained.

This function is a lightweight wrapper around \code{\link[=chat_openai]{chat_openai()}} with
the defaults tweaked for Perplexity AI.
}
\examples{
\dontrun{
chat <- chat_perplexity()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_bedrock}()},
\code{\link{chat_claude}()},
\code{\link{chat_cortex}()},
\code{\link{chat_databricks}()},
\code{\link{chat_gemini}()},
\code{\link{chat_github}()},
\code{\link{chat_groq}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()}
}
\concept{chatbots}
