% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-azure.R
\name{chat_azure}
\alias{chat_azure}
\title{Chat with a model hosted on Azure OpenAI}
\usage{
chat_azure(
  endpoint = azure_endpoint(),
  deployment_id,
  api_version = NULL,
  system_prompt = NULL,
  turns = NULL,
  api_key = NULL,
  token = deprecated(),
  credentials = NULL,
  api_args = list(),
  echo = c("none", "text", "all")
)
}
\arguments{
\item{endpoint}{Azure OpenAI endpoint url with protocol and hostname, i.e.
\verb{https://\{your-resource-name\}.openai.azure.com}. Defaults to using the
value of the \code{AZURE_OPENAI_ENDPOINT} envinronment variable.}

\item{deployment_id}{Deployment id for the model you want to use.}

\item{api_version}{The API version to use.}

\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{turns}{A list of \link{Turn}s to start the chat with (i.e., continuing a
previous conversation). If not provided, the conversation begins from
scratch.}

\item{api_key}{An API key to use for authentication. You generally should not
supply this directly, but instead set the \code{AZURE_OPENAI_API_KEY}
environment variable.}

\item{token}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} A literal Azure token to use
for authentication. Deprecated in favour of ambient Azure credentials or
an explicit \code{credentials} argument.}

\item{credentials}{A list of authentication headers to pass into
\code{\link[httr2:req_headers]{httr2::req_headers()}}, a function that returns them, or \code{NULL} to use
\code{token} or \code{api_key} to generate these headers instead. This is an escape
hatch that allows users to incorporate Azure credentials generated by other
packages into \pkg{ellmer}, or to manage the lifetime of credentials that
need to be refreshed.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
The \href{https://azure.microsoft.com/en-us/products/ai-services/openai-service}{Azure OpenAI server}
hosts a number of open source models as well as proprietary models
from OpenAI.
\subsection{Authentication}{

\code{chat_azure()} supports API keys and the \code{credentials} parameter, but it also
makes use of:
\itemize{
\item Azure service principals (when the \code{AZURE_TENANT_ID}, \code{AZURE_CLIENT_ID},
and \code{AZURE_CLIENT_SECRET} environment variables are set).
\item Interactive Entra ID authentication, like the Azure CLI.
\item Viewer-based credentials on Posit Connect. Requires the \pkg{connectcreds}
package.
}
}
}
\examples{
\dontrun{
chat <- chat_azure(deployment_id = "gpt-4o-mini")
chat$chat("Tell me three jokes about statisticians")
}
}
