% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap.R
\name{step_umap}
\alias{step_umap}
\alias{tidy.step_umap}
\title{Supervised and unsupervised uniform manifold approximation and projection (UMAP)}
\usage{
step_umap(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  outcome = NULL,
  neighbors = 15,
  num_comp = 2,
  min_dist = 0.01,
  learn_rate = 1,
  epochs = NULL,
  options = list(verbose = FALSE, n_threads = 1),
  seed = sample(10^5, 2),
  retain = FALSE,
  object = NULL,
  skip = FALSE,
  id = rand_id("umap")
)

\method{tidy}{step_umap}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables. For
\code{step_umap}, this indicates the variables to be encoded into a numeric
format. Numeric and factor variables can be used. See
\code{\link[recipes:selections]{recipes::selections()}} for more details. For the \code{tidy} method, these are
not currently used.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned?. By default, the function assumes that the new embedding
columns created by the original variables will be used as predictors in a
model.}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{outcome}{A call to \code{vars} to specify which variable is
used as the outcome in the encoding process (if any).}

\item{neighbors}{An integer for the number of nearest neighbors used to construct
the target simplicial set.}

\item{num_comp}{An integer for the number of UMAP components.}

\item{min_dist}{The effective minimum distance between embedded points.}

\item{learn_rate}{Positive number of the learning rate for the optimization
process.}

\item{epochs}{Number of iterations for the neighbor optimization. See
\code{\link[uwot:umap]{uwot::umap()}} for mroe details.}

\item{options}{A list of options to pass to \code{\link[uwot:umap]{uwot::umap()}}. The arguments
\code{X}, \code{n_neighbors}, \code{n_components}, \code{min_dist}, \code{n_epochs}, \code{ret_model}, and
\code{learning_rate} should not be passed here. By default, \code{verbose} and
\code{n_threads} are set.}

\item{seed}{Two integers to control the random numbers used by the
numerical methods. The default pulls from the main session's stream of
numbers and will give reproducible results if the seed is set prior to
calling \code{\link[=prep.recipe]{prep.recipe()}} or \code{\link[=bake.recipe]{bake.recipe()}}.}

\item{retain}{A single logical for whether the original predictors should
be kept (in addition to the new embedding variables).}

\item{object}{An object that defines the encoding. This is
\code{NULL} until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked
by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked when
\code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)). Care should
be taken when using \code{skip = TRUE} as it may affect the computations for
subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_umap} object.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any). For the \code{tidy} method, a tibble with a
column called \code{terms} (the selectors or variables for embedding) is
returned.
}
\description{
\code{step_umap} creates a \emph{specification} of a recipe step that
will project a set of features into a smaller space.
}
\details{
UMAP, short for Uniform Manifold Approximation and Projection, is a nonlinear
dimension reduction technique that finds local, low-dimensional
representations of the data. It can be run unsupervised or supervised with
different types of outcome data (e.g. numeric, factor, etc).
}
\examples{
library(recipes)
library(dplyr)
library(ggplot2)

split <- seq.int(1, 150, by = 9)
tr <- iris[-split, ]
te <- iris[ split, ]

set.seed(11)
supervised <- 
  recipe(Species ~ ., data = tr) \%>\%
  step_center(all_predictors()) \%>\% 
  step_scale(all_predictors()) \%>\% 
  step_umap(all_predictors(), outcome = vars(Species), num_comp = 2) \%>\% 
  prep(training = tr)

theme_set(theme_bw())

bake(supervised, new_data = te, Species, starts_with("umap")) \%>\% 
  ggplot(aes(x = umap_1, y = umap_2, col = Species)) + 
  geom_point(alpha = .5) 
}
\references{
McInnes, L., & Healy, J. (2018). UMAP: Uniform Manifold Approximation and
Projection for Dimension Reduction. \url{ https://arxiv.org/abs/1802.03426}.

"How UMAP Works" \url{https://umap-learn.readthedocs.io/en/latest/how_umap_works.html}
}
\concept{preprocessing encoding}
\keyword{datagen}
