% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HatchingSuccess.predict.R
\name{predict.HatchingSuccess}
\alias{predict.HatchingSuccess}
\title{Return prediction based on a model fitted with HatchingSuccess.fit()}
\usage{
\method{predict}{HatchingSuccess}(
  object,
  ...,
  temperature = NULL,
  probs = c(0.025, 0.5, 0.975),
  replicates = NULL,
  resultmcmc = NULL,
  chain = 1
)
}
\arguments{
\item{object}{The return of a fit done with HatchingSuccesss.fit().}

\item{...}{Not used}

\item{temperature}{A vector of temperatures.}

\item{probs}{Quantiles.}

\item{replicates}{Number of replicates to estimate the confidence interval.}

\item{resultmcmc}{Results obtained using HatchingSuccesss.MHmcmc()}

\item{chain}{Chain to use in resultmcmc}
}
\value{
Return a matrix with prediction based on a model fitted with HatchingSuccess.fit()
}
\description{
Set of functions to study the hatching success.\cr
If replicates is 0, it returns only the fitted model.\cr
If replicates is null and resultmcmc is not null, it will use all the mcmc data.\cr
if replicates is lower than the number of iterations in resultmcmc, it will use sequence of data regularly thined.
}
\details{
predict.HatchingSuccess returns prediction based on a model fitted with HatchingSuccessfit()
}
\examples{
\dontrun{
library(embryogrowth)
totalIncubation_Cc <- subset(DatabaseTSD, 
                             Species=="Caretta caretta" & 
                               Note != "Sinusoidal pattern" & 
                               !is.na(Total) & Total != 0)

par <- c(S.low=0.5, S.high=0.3, 
         P.low=25, deltaP=10, MaxHS=0.8)
         
HatchingSuccess.lnL(x=par, data=totalIncubation_Cc)

g <- HatchingSuccess.fit(par=par, data=totalIncubation_Cc)

HatchingSuccess.lnL(par=g$par, data=totalIncubation_Cc)

plot(g)
}
}
\seealso{
Other Hatching success: 
\code{\link{HatchingSuccess.MHmcmc_p}()},
\code{\link{HatchingSuccess.MHmcmc}()},
\code{\link{HatchingSuccess.fit}()},
\code{\link{HatchingSuccess.lnL}()},
\code{\link{HatchingSuccess.model}()},
\code{\link{logLik.HatchingSuccess}()},
\code{\link{nobs.HatchingSuccess}()},
\code{\link{plot.HatchingSuccess}()}
}
\author{
Marc Girondot
}
\concept{Hatching success}
