% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty.datalogger.R
\name{uncertainty.datalogger}
\alias{uncertainty.datalogger}
\title{Uncertainty of average temperatures obtained using temperature data logger}
\usage{
uncertainty.datalogger(
  max.time = 0,
  sample.rate = 0,
  accuracy = 0.5,
  resolution = 1,
  replicates = 10000,
  method = function(x) {     2 * qnorm(0.975) * sd(x) }
)
}
\arguments{
\item{max.time}{being the maximum time to record in minutes}

\item{sample.rate}{The sample rates in minutes}

\item{accuracy}{The accuracy of the data logger in °C}

\item{resolution}{The resolution of the data logger in °C}

\item{replicates}{The number of replicates to estimate uncertainty.}

\item{method}{The fonction that will be used to return the uncertainty.}
}
\value{
The function will return the uncertainty of the average temperature for the considered period as being the 95% range where the true average temperature should be.
}
\description{
Calculate the uncertainty of average temperature dependent on the 
characteristics of a data logger and sampling rate.\cr
The temperature is supposed to be uniformaly distributed with min and max 
being -accuracy and +accuracy.
}
\details{
uncertainty.datalogger Calculate the uncertainty of the average temperature calculated using data gathered by a data logger.
}
\examples{
\dontrun{
library(embryogrowth)
# Exemple using the hypothesis of Gaussian distribution
uncertainty.datalogger(sample.rate=30, accuracy=1, resolution=0.5, 
                method=function(x) {2*qnorm(0.975)*sd(x)})
# Example without hypothesis about distribution, using quantiles
uncertainty.datalogger(sample.rate=30, accuracy=1, resolution=0.5, 
                method=function(x) {quantile(x, probs=c(0.975))-
                                              quantile(x, probs=c(0.025))})
par(mar=c(4, 4, 1, 1))
plot(x=10:120, uncertainty.datalogger(sample.rate=10:120, 
                                      accuracy=0.5, 
                                      resolution=1), 
     las=1, bty="n", type="l", 
     xlab="Sample rate in minutes", 
     ylab=expression("Uncertainty in "*degree*"C"), 
     ylim=c(0, 0.15), xlim=c(0, 120))  
lines(x=10:120, uncertainty.datalogger(sample.rate=10:120, 
                                            accuracy=1, 
                                            resolution=0.5), col="red")
lines(x=10:120, uncertainty.datalogger(sample.rate=10:120, 
                                       accuracy=1, 
                                       resolution=1), col="blue")
lines(x=10:120, uncertainty.datalogger(sample.rate=10:120, 
                                       accuracy=0.5, 
                                       resolution=0.5), col="yellow")
legend("topleft", legend=c("Accuracy=0.5, resolution=0.5", 
                           "Accuracy=0.5, resolution=1", 
                           "Accuracy=1, resolution=0.5", 
                           "Accuracy=1, resolution=1"), lty=1, 
       col=c("yellow", "black", "red", "blue"), 
       cex=0.6)
}
}
\seealso{
Other Data loggers utilities: 
\code{\link{calibrate.datalogger}()},
\code{\link{movement}()}
}
\author{
Marc Girondot
}
\concept{Data loggers utilities}
