% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HatchingSuccess.model.R
\name{HatchingSuccess.model}
\alias{HatchingSuccess.model}
\title{Return the hatching success according the set of parameters and temperatures}
\usage{
HatchingSuccess.model(par, temperature)
}
\arguments{
\item{par}{A set of parameters.}

\item{temperature}{A vector of temperatures.}
}
\value{
Return the hatching success according the set of parameters and temperatures
}
\description{
Set of functions to study the hatching success.\cr
}
\details{
HatchingSuccess.model returns the hatching success according the set of parameters and temperatures
}
\examples{
\dontrun{
library(embryogrowth)
totalIncubation_Cc <- subset(DatabaseTSD, 
                             Species=="Caretta caretta" & 
                               Note != "Sinusoidal pattern" & 
                               !is.na(Total) & Total != 0)

par <- c(S.low=0.5, S.high=0.3, 
         P.low=25, deltaP=10, MaxHS=0.8)
         
HatchingSuccess.lnL(par=par, data=totalIncubation_Cc)

g <- HatchingSuccess.fit(par=par, data=totalIncubation_Cc)

HatchingSuccess.lnL(par=g$par, data=totalIncubation_Cc)

plot(g)
}
}
\seealso{
Other Hatching success: 
\code{\link{HatchingSuccess.MHmcmc}()},
\code{\link{HatchingSuccess.MHmcmc_p}()},
\code{\link{HatchingSuccess.fit}()},
\code{\link{HatchingSuccess.lnL}()},
\code{\link{logLik.HatchingSuccess}()},
\code{\link{nobs.HatchingSuccess}()},
\code{\link{predict.HatchingSuccess}()}
}
\author{
Marc Girondot
}
\concept{Hatching success}
