% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.emdi.R
\name{summary.emdi}
\alias{summary.emdi}
\title{Summarizes an emdiObject}
\usage{
\method{summary}{emdi}(object, ...)
}
\arguments{
\item{object}{an object of type "emdi", representing point and MSE
estimates. Objects differ depending on the estimation method: direct
vs. model-based.}

\item{...}{additional arguments that are not used in this method.}
}
\value{
an object of type "summary.emdi" with information about the 
sample and population data, the usage of transformation, normality 
tests and information of the model fit.
}
\description{
Additional information about the data and model in small area estimation
methods and components of an emdi object are extracted. The returned object
is suitable for printing  with the \code{print.summary.emdi} method.
}
\examples{
\donttest{
# Example for models of type ebp

# Loading data - population and sample data
data("eusilcA_pop")
data("eusilcA_smp")

# Example with two additional indicators
emdi_model <- ebp(fixed = eqIncome ~ gender + eqsize + cash +
self_empl + unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent +
fam_allow + house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
threshold = function(y){0.6 * median(y)}, L = 50, MSE = TRUE, B = 50,
custom_indicator = list( my_max = function(y, threshold){max(y)},
my_min = function(y, threshold){min(y)}), na.rm = TRUE, cpus = 1)

# Example 1: Receive first overview
summary(emdi_model)


# Example for models of type fh

# Loading data - population and sample data
data("eusilcA_popAgg")
data("eusilcA_smpAgg")

# Combine sample and population data
combined_data <- combine_data(pop_data = eusilcA_popAgg, pop_domains = "Domain",
                              smp_data = eusilcA_smpAgg, smp_domains = "Domain")

# Generation of the emdi object
fh_std <- fh(fixed = Mean ~ cash + self_empl, vardir = "Var_Mean",
             combined_data = combined_data, domains = "Domain", method = "ml", 
             MSE = TRUE)
             
# Example 2: Receive first overview
summary(fh_std)
}
}
\references{
Lahiri, P. and Suntornchost, J. (2015), Variable selection for linear mixed
models with applications in small area estimation, The Indian Journal of 
Statistics 77-B(2), 312-320. \cr \cr
Marhuenda, Y., Morales, D. and Pardo, M.C. (2014). Information criteria for 
Fay-Herriot model selection. Computational Statistics and Data Analysis 70, 
268-280. \cr \cr
Nakagawa S, Schielzeth H (2013). A general and simple method for obtaining R2 
from generalized linear mixed-effects models. Methods in Ecology and Evolution, 
4(2), 133-142.
}
\seealso{
\code{\link{emdiObject}}, \code{\link{direct}}, \code{\link{ebp}},
\code{\link{fh}}, \code{\link[MuMIn]{r.squaredGLMM}}, \code{\link[moments]{skewness}},
\code{\link[moments]{kurtosis}}, \code{\link[stats]{shapiro.test}}
}
