% Generated by roxygen2 (4.0.1): do not edit by hand
\name{subframe}
\alias{subframe}
\title{Extract and organize predictions according to a resampling scheme}
\usage{
subframe(x, ..., resample)
}
\arguments{
\item{x}{Performance evaluation results.}

\item{...}{Indexes specify what to extract, sent to \code{\link{subtree}}.}

\item{resample}{Resampling scheme used to carry out a performance
evaluation.}
}
\description{
This function arranges predictions of a performance evaluation in a data
frame where the rows correspond do observations and the columns to folds, to
make it easy to study the variability of each observation with respect to
the resampling.
}
\examples{
proc <- modeling.procedure("lda")
cv <- resample("crossval", y=iris$Species, nfold=5, nrep=3)
perf <- evaluate.modeling(proc, x=iris[-5], y=iris$Species, resample=cv)
subframe(perf, TRUE, "pred", "prob", 1, resample=cv)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{subtree}}
}

