% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reshape-result.r
\name{select}
\alias{select}
\alias{select_.list}
\alias{select_.modeling_result}
\title{\pkg{emil} and \pkg{dplyr} integration}
\usage{
\method{select_}{list}(.data, ..., .dots)

\method{select_}{modeling_result}(.data, ..., .dots)
}
\arguments{
\item{.data}{Modeling results, as returned by \code{\link{evaluate}}.}

\item{...}{Not used, kept for consistency with \code{dplyr}.}

\item{.dots}{Indices to select on each level of \code{.data}, i.e.
  the first index specifies which top level elements of \code{.data} to
  select, the second specifies second-level-elements etc.
  The last index must select elements that can be converted to a data frame.
  In case the desired bottom-level element is related to the observations of
  a modeling task, e.g. the predctions of a test set, you must supply the
  resampling scheme used to produce \code{.data} at the appropriate level
  (see the examples).

  The names of the \code{...} arguments specifies the names of the resulting
  data frame. Non-named arguments will be used to traverse the data but not
  returned.

  In summary the \code{...} indices can be on the following forms:
  \describe{
    \item{Simple indices}{Anything that can be used to subset objects,
      e.g. integers, logicals, or characters.}
    \item{Functions}{A function that produces a data frame, vector or
      factor.}
    \item{Resampling schemes}{The same resampling scheme that was used to
      produce the modeling results.}
  }}
}
\value{
A \code{\link{data.frame}} in long format.
}
\description{
Modeling results can be converted to tabular format and manipulated using
\pkg{dplyr} and other Hadleyverse packages. This is accomplished by a class
specific \code{\link[dplyr]{select_}} function that differs somewhat in syntax
from the default \code{\link[dplyr]{select_}}.
}
\examples{
# Produce some results
x <- iris[-5]
y <- iris$Species
names(y) <- sprintf("orchid\%03i", seq_along(y))
cv <- resample("crossvalidation", y, nfold=3, nrepeat=2)
procedures <- list(nsc = modeling_procedure("pamr"),
                   rf = modeling_procedure("randomForest"))
result <- evaluate(procedures, x, y, resample=cv)

# Get the foldwise error for the NSC method
result \%>\% select(fold = TRUE, "nsc", error = "error")

# Compare both methods
require(tidyr)
result \%>\%
    select(fold = TRUE, method = TRUE, error = "error") \%>\%
    spread(method, error)
require(dplyr)
result \%>\%
    select(fold = TRUE, method = TRUE, error = "error") \%>\%
    group_by(method) \%>\% summarize(mean_error = mean(error))

# Investigate the variability in estimated class 2 probability across folds
result \%>\%
    select(fold = cv, "nsc", "prediction", probability = function(x) x$probability[,2]) \%>\%
    spread(fold, probability)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
subtree
}

