% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwpp.R
\name{pwpp}
\alias{pwpp}
\title{Pairwise P-value plot}
\usage{
pwpp(emm, method = "pairwise", by, sort = TRUE, values = TRUE,
  rows = ".", xlab, ylab, xsub = "", plim = numeric(0), add.space = 0,
  aes, ...)
}
\arguments{
\item{emm}{An \code{emmGrid} object}

\item{method}{Character or list. Passed to \code{\link{contrast}}, and defines 
the contrasts to be displayed. Any contrast method may be used,
provided that each contrast includes one coefficient of \code{1},
one coefficient of \code{-1}, and the rest \code{0}. That is, calling
\code{contrast(object, method)} produces a set of comparisons, each with
one estimate minus another estimate.}

\item{by}{Character vector of variable(s) in the grid to condition on. These will
create different panels, one for each level or level-combination.
Grid factors not in \code{by} are the \emph{primary} factors: 
whose levels or level combinations are compared pairwise.}

\item{sort}{Logical value. If \code{TRUE}, levels of the factor combinations are
ordered by their marginal means. If \code{FALSE}, they appear in
order based on the existing ordering of the factor levels involved.
Note that the levels are ordered the same way in all panels, and in
many cases this implies that the means in any particular panel
will \emph{not} be ordered even when \code{sort = TRUE}.}

\item{values}{Logical value. If \code{TRUE}, the values of the EMMs are included
in the plot. When there are several side-by-side panels due
to \code{by} variable(s), the labels showing values start
stealing a lot of space from the plotting area; in those cases,
it may be desirable to specify \code{FALSE} or use \code{rows}
so that some panels are vertically stacked.}

\item{rows}{Character vector of which \code{by} variable(s) are used to define
rows of the panel layout. Those variables in \code{by} not included in 
\code{rows} define columns in the array of panels.
A \code{"."} indicates that only one row
is used, so all panels are stacked side-by-side.}

\item{xlab}{Character label to use in place of the default for the P-value axis.}

\item{ylab}{Character label to use in place of the default for the primary-factor axis.}

\item{xsub}{Character label used as caption at the lower right of the plot.}

\item{plim}{numeric vector of value(s) between 0 and 1. These are included
among the observed p values so that the range of tick marks includes at
least the range of \code{plim}. Choosing \code{plim = c(0,1)} will ensure
the widest possible range.}

\item{add.space}{Numeric value to adjust amount of space used for value labels. Positioning
of value labels is tricky, and depends on how many panels and the
physical size of the plotting region. This parameter allows the user to
adjust the position. Changing it by one unit should shift the position by
about one character width (right if positive, left if negative).
Note that this interacts with \code{aes$label} below.}

\item{aes}{optional named list of lists. Entries considered are \code{point}, 
\code{segment}, and \code{label}, and contents are passed to the respective
\code{ggplot2::geom_xxx()} functions. These affect rendering of points, 
line segments joining them, and value labels. 
Defaults are \code{point = list(size = 2)},
\code{segment = list()}, and \code{label = list(size = 2.5)}.}

\item{...}{Additional arguments passed to \code{contrast} and \code{\link{summary.emmGrid}}, 
as well as to \code{geom_segment} and \code{geom_label}}
}
\description{
Constructs a plot of P values associated with pairwise comparisons of 
estimated marginal means.
}
\details{
Factor levels (or combinations thereof) are plotted on the vertical scale, and P values
are plotted on the horizontal scale. Each P value is plotted twice -- at
vertical positions corresponding to the levels being compared -- and connected by
a line segment. Thus, it is easy to visualize which P values are small and large,
and which levels are compared. In addition, factor levels are color-coded, and the points
and half-line segments appear in the color of the other level.
The P-value scale is nonlinear, so as to stretch-out smaller P values and
compress larger ones.
P values smaller than 0.0004 are altered and plotted in a way that makes 
  them more distinguishable from one another.

If \code{xlab}, \code{ylab}, and \code{xsub} are not provided, reasonable labels
are created. \code{xsub} is used to note special features; e.g., equivalence
thresholds or one-sided tests.
}
\note{
If \code{emm} is the result of a Bayesian analysis, the plot is based on
  summaries with \code{frequentist = TRUE}.

The \pkg{ggplot2} and \pkg{scales} packages must be installed in order 
  for \code{pwpp} to work.

Additional plot aesthetics are available by adding them to the returned object;
  see the examples
}
\examples{
pigs.lm <- lm(log(conc) ~ source * factor(percent), data = pigs)
emm = emmeans(pigs.lm, ~ percent | source)
pwpp(emm)
pwpp(emm, method = "trt.vs.ctrl1", type = "response", side = ">")

# custom aesthetics:
my.aes <- list(point = list(shape = "square"), 
               segment = list(linetype = "dashed", color = "red"),
               label = list(family = "serif", fontface = "italic"))
my.pal <- c("darkgreen", "blue", "magenta", "orange")
pwpp(emm, aes = my.aes) + ggplot2::scale_color_manual(values = my.pal)

}
\seealso{
A numerical display of essentially the same results is available
  from \code{\link{pwpm}}
}
