% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{encode}
\alias{encode}
\title{Encode Factor-like Levels and Labels as a Simple String}
\usage{
encode(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}
}
\description{
For compact storage, \code{encode} combines a set of levels and labels
(codes and decodes) into a simple string.  The default method converts its
argument to character.  The list method operates element-wise, expecting and
equal number of label elements, each of which have the same length as the
corresponding element of x.
}
\details{
An 'encoding' must be at least 5 characters long, beginning and ending with
two instances of \code{sep}. Specified levels are likewise separated by
double separators. If a label (decode) is available for a level, it follows
the corresponding level: the two are separated by a single instance of
\code{sep}.  Separators may be mixed within an encoded vector, but not
within an element.  \code{--0-male--1-female--} indicates that the value 0
represents the concept "male" and the value 1 represents "female".

If you don't supply the separator, \code{encode} uses the first of these that is not otherwise present in the result: /|:\\~!@#$%^&*?. (including dot).
}
\examples{

a <- encode(
  x = list(
    c('M','F'),
    c(1:4)
  ),
  labels = list(
    c('male','female'),
    c('caucasian','asian','african',NA)
  )
)
b <- encode(c(1:2),c('pediatric','adult'))
a
b
c <- c('a',NA,'##b##')
encoded(a)
encoded(b)
encoded(c)
encoded(' //4// ')
codes(a)
codes(b)
codes(b,simplify=FALSE)
codes(c)
codes('..1..')
decodes(a)
decodes(b)
decodes(c)
decode(1:4,'//1/a//2/b//3/c//')
}
\seealso{
\code{\link{encode.character}} \code{\link{encode.default}} \code{\link{encode.list}} \code{\link{codes}} \code{\link{decodes}} \code{\link{decode}} \code{\link{encoded}}
}
