% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padronizar_bairros.R
\name{padronizar_bairros}
\alias{padronizar_bairros}
\title{Padronizar bairros}
\usage{
padronizar_bairros(bairros)
}
\arguments{
\item{bairros}{Um vetor de caracteres. Os bairros a serem padronizados.}
}
\value{
Um vetor de caracteres com os bairros padronizados.
}
\description{
Padroniza um vetor de caracteres representando bairros de municípios
brasileiros. Veja a seção \emph{Detalhes} para mais informações sobre a
padronização.
}
\section{Detalhes}{

Operações realizadas durante a padronização:
\itemize{
\item remoção de espaços em branco antes e depois das strings e remoção de
espaços em excesso entre palavras;
\item conversão de caracteres para caixa alta;
\item remoção de acentos e caracteres não ASCII;
\item adição de espaços após abreviações sinalizadas por pontos;
\item expansão de abreviações frequentemente utilizadas através de diversas
\href{https://en.wikipedia.org/wiki/Regular_expression}{expressões regulares (regexes)};
\item correção de alguns pequenos erros ortográficos.
}
}

\examples{
bairros <- c("PRQ IND", "NSA SEN DE FATIMA", "ILHA DO GOV")
padronizar_bairros(bairros)

}
