% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.engressionBagged.R
\name{print.engressionBagged}
\alias{print.engressionBagged}
\title{Print a Bagged Engression Model Object}
\usage{
\method{print}{engressionBagged}(x, ...)
}
\arguments{
\item{x}{A trained bagged engression model object returned from
the engressionBagged function.}

\item{...}{additional arguments (currently ignored)}
}
\value{
This function does not return anything. It prints a summary of the
model, including the architecture of the individual models, the number
of models in the bagged ensemble, and the loss values achieved at several
epochs during training.
}
\description{
This function displays a summary of a bagged Engression model object. The
summary includes details about the individual models as well as the overall
ensemble.
}
\examples{
\donttest{
  n = 1000
  p = 5
  X = matrix(rnorm(n*p),ncol=p)
  Y = (X[,1]+rnorm(n)*0.1)^2 + (X[,2]+rnorm(n)*0.1) + rnorm(n)*0.1
  
  ## fit bagged engression object
  engb = engressionBagged(X,Y,K=3)
  print(engb)

}

}
