% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enspls.fs.R
\name{enspls.fs}
\alias{enspls.fs}
\title{Ensemble Sparse Partial Least Squares for Feature Selection}
\usage{
enspls.fs(x, y, maxcomp = 5L, alpha = seq(0.2, 0.8, 0.2), MCtimes = 500L,
  method = c("mc", "bootstrap"), ratio = 0.8, parallel = 1L)
}
\arguments{
\item{x}{predictor matrix}

\item{y}{response vector}

\item{maxcomp}{Maximum number of components included within the models,
if not specified, default is 5.}

\item{alpha}{Parameter (grid) controlling sparsity of the model.
If not specified, default is \code{seq(0.2, 0.8, 0.2)}.}

\item{MCtimes}{times of Monte-Carlo}

\item{method}{\code{"mc"} or \code{"bootstrap"}. Default is \code{"mc"}.}

\item{ratio}{sample ratio used when \code{method = "mc"}}

\item{parallel}{Integer. Number of CPU cores to use.
Default is \code{1} (not parallelized).}
}
\value{
A list containing two components:
\itemize{
\item \code{variable.importance} - a vector of variable importance
\item \code{coefficient.matrix} - original coefficient matrix
}
}
\description{
Feature selection with ensemble sparse partial least squares.
}
\examples{
data("logd1k")
x = logd1k$x
y = logd1k$y

set.seed(42)
fs = enspls.fs(x, y, MCtimes = 5, maxcomp = 2)
print(fs, nvar = 10)
plot(fs, nvar = 10)
plot(fs, type = 'boxplot', limits = c(0.05, 0.95), nvar = 10)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enspls.od}} for outlier detection with
ensemble sparse partial least squares regression.
See \code{\link{enspls.fit}} for ensemble sparse
partial least squares regression.
}

