% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enpls.fit.R
\name{enpls.fit}
\alias{enpls.fit}
\title{Ensemble Partial Least Squares Regression}
\usage{
enpls.fit(x, y, maxcomp = NULL, cvfolds = 5L, reptimes = 500L,
  method = c("mc", "boot"), ratio = 0.8, parallel = 1L)
}
\arguments{
\item{x}{Predictor matrix.}

\item{y}{Response vector.}

\item{maxcomp}{Maximum number of components included within each model.
If not specified, will use the maximum number possible (considering
cross-validation and special cases where n is smaller than p).}

\item{cvfolds}{Number of cross-validation folds used in each model
for automatic parameter selection, default is \code{5}.}

\item{reptimes}{Number of models to build with Monte-Carlo resampling
or bootstrapping.}

\item{method}{Resampling method. \code{"mc"} (Monte-Carlo resampling)
or \code{"boot"} (bootstrapping). Default is \code{"mc"}.}

\item{ratio}{Sampling ratio used when \code{method = "mc"}.}

\item{parallel}{Integer. Number of CPU cores to use.
Default is \code{1} (not parallelized).}
}
\value{
A list containing all partial least squares model objects.
}
\description{
Ensemble partial least squares regression.
}
\examples{
data("alkanes")
x = alkanes$x
y = alkanes$y

set.seed(42)
fit = enpls.fit(x, y, reptimes = 50)
print(fit)
predict(fit, newx = x)
}
\seealso{
See \code{\link{enpls.fs}} for measuring feature importance
with ensemble partial least squares regressions.
See \code{\link{enpls.od}} for outlier detection with ensemble
partial least squares regressions.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
