% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.enspls.R
\name{predict.enspls.fit}
\alias{predict.enspls.fit}
\title{Make Predictions from a Fitted Sparse Ensemble Partial Least Squares Model}
\usage{
\method{predict}{enspls.fit}(object, newx, method = c("mean", "median"),
  ...)
}
\arguments{
\item{object}{An object of class \code{enspls.fit}.}

\item{newx}{New data to predict with.}

\item{method}{Use \code{"mean"} or \code{"median"} to create
the final prediction.}

\item{...}{Additional parameters for \code{\link{predict}}.}
}
\value{
A numeric vector containing the predicted values.
}
\description{
Make predictions on new data by fitted enspls.fit object.
}
\examples{
data("logd1k")
x <- logd1k$x
y <- logd1k$y

set.seed(42)
fit <- enspls.fit(x, y, reptimes = 5, maxcomp = 2)
y.pred <- predict(fit, newx = x)
plot(y, y.pred, xlim = range(y), ylim = range(y))
abline(a = 0L, b = 1L)
y.pred.med <- predict(fit, newx = x, method = "median")
plot(y, y.pred.med, xlim = range(y), ylim = range(y))
abline(a = 0L, b = 1L)
}
\seealso{
See \code{\link{enspls.fit}} for fitting ensemble sparse
partial least squares regression models.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
