% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2dist.R
\name{enve.df2dist}
\alias{enve.df2dist}
\title{Enveomics: Data Frame to Dist}
\usage{
enve.df2dist(
  x,
  obj1.index = 1,
  obj2.index = 2,
  dist.index = 3,
  default.d = NA,
  max.sim = 0
)
}
\arguments{
\item{x}{A dataframe (or coercible object) with at least three columns:
\enumerate{
   \item ID of the object 1, 
   \item ID of the object 2, and 
   \item distance between the two objects.}}

\item{obj1.index}{Index of the column containing the ID of the object 1.}

\item{obj2.index}{Index of the column containing the ID of the object 2.}

\item{dist.index}{Index of the column containing the distance.}

\item{default.d}{Default value (for missing values).}

\item{max.sim}{If not zero, assumes that the values are similarity
(not distance) and this is the maximum similarity (corresponding to 
distance 0). Applies transformation: 
\eqn{distance = (max.sim - values)/max.sim.}}
}
\value{
Returns a \strong{dist} object.
}
\description{
Transform a dataframe (or coercible object, like a table) into a
\strong{dist} object.
}
\author{
Luis M. Rodriguez-R [aut, cre]
}
