% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aridityIndexThornthwaite.R
\name{aridityIndexThornthwaite}
\alias{aridityIndexThornthwaite}
\title{aridityIndexThornthwaite}
\usage{
aridityIndexThornthwaite(precipStack, PETstack, precipScale = 1)
}
\arguments{
\item{precipStack}{SpatRaster of monthly precipitation.}

\item{PETstack}{SpatRaster of monthly potential evapotranspiration. 
Layer names are assumed to end in the month number.}

\item{precipScale}{integer; scaling factor for the precipitation data, see \link{envirem}
for additional details.}
}
\value{
RasterLayer, unitless
}
\description{
Generates thornthwaite aridity index raster.
}
\details{
\code{Thornthwaite aridity index = 100d / n}
where d = sum of monthly differences between precipitation and PET for months where precip < PET
where n = sum of monthly PET for those months
}
\examples{
\donttest{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- rast(rasterFiles)

# identify the appropriate layers
meantemp <- grep('mean', names(env), value=TRUE)
solar <- grep('solrad', names(env), value=TRUE)
maxtemp <- grep('tmax', names(env), value=TRUE)
mintemp <- grep('tmin', names(env), value=TRUE)

# read them in as SpatRasters
meantemp <- env[[meantemp]]
solar <- env[[solar]]
maxtemp <- env[[maxtemp]]
mintemp <- env[[mintemp]]
tempRange <- abs(maxtemp - mintemp)

# get monthly PET
pet <- monthlyPET(meantemp, solar, tempRange)

precip <- grep('prec', names(env), value=TRUE)
precip <- env[[precip]]

# set up naming scheme - only precip is different from default
assignNames(precip = 'prec_##')

aridityIndexThornthwaite(precip, pet)

# set back to defaults
assignNames(reset = TRUE)
}

}
\references{
Thornthwaite, C.W. (1948). An approach toward a rational classification of climate.
\emph{Geographical Review}, \strong{38}, 55-94.
}
\seealso{
Requires rasters created with \code{\link{monthlyPET}}.
}
\author{
Pascal Title
}
