% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rtoolkit.R
\name{ENopen}
\alias{ENopen}
\title{Open the EPANET Toolkit.}
\usage{
ENopen(inpFileName, rptFileName, outFileName)
}
\arguments{
\item{inpFileName}{A string, the name of the EPANET Input file.}

\item{rptFileName}{A string, the name of the EPANET Report file.}

\item{outFileName}{A string, the name of an optional binary Output file.}
}
\value{
returns NULL invisibly on success or raises an error or warning.
}
\description{
\code{ENopen} opens the EPANET Toolkit to analyze a particular water distribution system.
}
\note{
If there is no need to save an EPANET's binary Output file, then \code{outFileName}
  can be an empty string ("").
  
  If \code{rptFileName} is an empty string, reporting will be made to the operating system 
  \code{stdout} device (which is usually the console/terminal).
  
  \code{enOpen} must be called before any of the other toolkit functions are used. The only
  exception is \code{enEpanet}.
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENclose()
}
\seealso{
\code{ENclose}  
\url{http://wateranalytics.org/EPANET/group___file_management.html}
}
