% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.r
\name{ENgetoption}
\alias{ENgetoption}
\title{Retrieve the value of an analysis option.}
\usage{
ENgetoption(optioncode)
}
\arguments{
\item{optioncode}{A character or integer specifying the option code 
(see below).}
}
\value{
numeric value of the specified analysis option(s).
}
\description{
\code{ENgetoption} retrieves the value of one or more particular analysis options.
}
\details{
Option codes consist of the following constants:
  \tabular{ll}{
  \code{EN_TRIALS}     \tab   0  \cr
  \code{EN_ACCURACY}   \tab   1  \cr
  \code{EN_TOLERANCE}  \tab   2  \cr
  \code{EN_EMITEXPON}  \tab   3  \cr
  \code{EN_DEMANDMULT} \tab   4  
  }
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetoption(0)
ENgetoption("EN_TRIALS")
ENclose()
}
