% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPCC_RCP8_5.R
\name{IPCC_RCP8_5}
\alias{IPCC_RCP8_5}
\title{IPCC RCP8.5 scenario}
\usage{
IPCC_RCP8_5(
  y_ini = c(N = 400, N = 400, N = 400),
  temp_ini = rep(20, 3),
  temp_cmin = rep(18, 3),
  temp_cmax = c(25, 28, 30),
  ro = rep(0.7, 3),
  lambda = rep(5e-05, 3),
  time_start = 2005,
  time_end = 2100,
  leap = 1/12
)
}
\arguments{
\item{y_ini}{Initial population values (must be written with its name: N).}

\item{temp_ini}{Initial temperature.}

\item{temp_cmin}{Minimum critical temperature.}

\item{temp_cmax}{Maximum critical temperature.}

\item{ro}{Population growth rate at optimum temperature.}

\item{lambda}{Marginal loss by non-thermodependent intraspecific competition.}

\item{time_start}{Start of time sequence.}

\item{time_end}{End of time sequence.}

\item{leap}{Time sequence step.}
}
\value{
(1) A data.frame with columns having the simulated trends.

(2) A two-panel figure in which (a) shows the population abundance curves represented by solid
           lines and the corresponding carrying capacities are represented by shaded areas. In (b) the
           temperature trend is shown. The three simultaneous simulations are depicted by different colors,
           i.e. 1st brown, 2nd green and 3rd blue.
}
\description{
This function allows simulating the effect of an increase in environmental
             temperature according to the IPCC RCP8.5 scenario (2014) on the abundance of
             ectotherm populations.
}
\details{
Three populations can be simulated simultaneously. The temperature trend is determined
        by a projection of the change in global mean surface temperature according to the IPCC
        RCP8.5 scenario. In each input vector, the parameters for the three simulations must be
        specified (finite numbers for initial population abundance). The simulations are obtained
        by a model that incorporates the effects of temperature over time, which leads to a
        non-autonomous ODE approach. This is function uses the ODE solver implemented in the package
        deSolve (Soetaert et al., 2010).
}
\examples{

#######################################################################
  #Example 1: Different initial population abundances.
#######################################################################

IPCC_RCP8_5(y_ini = c(N = 100, N = 200, N = 400),
           temp_ini = rep(26,3),
           temp_cmin = rep(18,3),
           temp_cmax = rep(30,3),
           ro = rep(0.7,3),
           lambda = rep(0.00005,3),
           time_start = 2005,
           time_end = 2100,
           leap = 1/12)

#######################################################################
  #Example 2: Different thermal tolerance ranges.
#######################################################################

temp_cmin3 <- 18
temp_cmin2 <- 10/9*temp_cmin3
temp_cmin1 <- 10/9*temp_cmin2

temp_cmax1 <- 32.4
temp_cmax2 <- 10/9*temp_cmax1
temp_cmax3 <- 10/9*temp_cmax2

IPCC_RCP8_5(y_ini = c(N = 100, N = 100, N = 100),
           temp_ini = rep(30,3),
           temp_cmin = c(temp_cmin1,temp_cmin2,temp_cmin3),
           temp_cmax = c(temp_cmax1,temp_cmax2,temp_cmax3),
           ro = rep(0.7,3),
           lambda = rep(0.00005,3),
           time_start = 2005,
           time_end = 2100,
           leap = 1/12)
\donttest{
#######################################################################
  #Example 3: Different relationships between initial environmental
  #           temperature and optimum temperature.
#######################################################################

temp_cmin <- 18
temp_cmax <- 30

# Temperature at which performance is at its maximum value.
temp_op <- (temp_cmax+temp_cmin)/3+sqrt(((temp_cmax+temp_cmin)/3)^2-
           (temp_cmax*temp_cmin)/3)

temp_ini1 <- (temp_cmin+temp_op)/2
temp_ini2 <- temp_op
temp_ini3 <- (temp_op+temp_cmax)/2

IPCC_RCP8_5(y_ini = c(N = 100, N = 100, N = 100),
           temp_ini = c(temp_ini1,temp_ini2,temp_ini3),
           temp_cmin = rep(temp_cmin,3),
           temp_cmax = rep(temp_cmax,3),
           ro = rep(0.7,3),
           lambda = rep(0.00005,3),
           time_start = 2005,
           time_end = 2100,
           leap = 1/12)

#######################################################################
  #Example 4:  Different marginal losses by a non-thermodependent
  #            component of intraspecific competition.
#######################################################################

lambda3 <- 0.01
lambda2 <- 1/2*lambda3
lambda1 <- 1/2*lambda2

IPCC_RCP8_5(y_ini = c(N = 100, N = 100,N = 100),
           temp_cmin = rep(18,3),
           temp_ini = rep(25,3),
           temp_cmax = rep(30,3),
           ro = rep(0.7,3),
           lambda = c(lambda1,lambda2,lambda3),
           time_start = 2005,
           time_end = 2100,
           leap = 1/12)
}
}
\references{
IPCC. (2014): Climate Change 2014: Synthesis Report. Contribution of Working Groups I,
           II and III to the Fifth Assessment Report of the Intergovernmental Panel on Climate
           Change [Core Writing Team, R.K. Pachauri and L.A. Meyer (eds.)]. IPCC, Geneva,
           Switzerland, 151 pp.

Soetaert, K., Petzoldt, T., & Setzer, R. (2010). Solving Differential Equations in R: Package
           deSolve. Journal of Statistical Software, 33(9), 1 - 25.
           doi:http://dx.doi.org/10.18637/jss.v033.i09
}
