% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.r
\name{get_hispanic_white_wage_gap}
\alias{get_hispanic_white_wage_gap}
\title{Retreive the percent by which hourly wages of Hispanic workers are less than hourly wages of white workers}
\usage{
get_hispanic_white_wage_gap(by = NULL)
}
\arguments{
\item{by}{\code{NULL} or \code{g} for a parition by gender}
}
\value{
\code{tbl_df} with data filtered by the selected criteria.
}
\description{
The Hispanic-white wage gap is the percent by which hourly wages of Hispanic workers
are less than hourly wages of white workers. It is also often expressed as a wage ratio
(Hispanic workers' share of white workers' wages) by subtracting the gap from 100 percent.
}
\details{
\itemize{
\item{A median Hispanic-white wage gap of 29.6 percent means that a typical Hispanic
      worker is paid 29.6 percent less per hour than a typical white worker.}
\item{An average Hispanic-white wage gap of 30.1 percent means that on average Hispanic
      workers are paid 30.1 percent less per hour than white workers.}
\item{A regression-based Hispanic-white wage gap of 11.1 percent means that on average
      Hispanic workers are paid 11.1 percent less per hour than white workers, all
      else held equal (controlling for gender, race and ethnicity, education,
      experience, and geographic location).}
}
}
\examples{
get_hispanic_white_wage_gap()

get_hispanic_white_wage_gap("g")
}
\references{
\href{http://www.epi.org/data/}{Economic Policy Institute Data Library}
}
