% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.r
\name{get_wage_ratios}
\alias{get_wage_ratios}
\title{Retreive the level of inequality within the hourly wage distribution.}
\usage{
get_wage_ratios(by = NULL)
}
\arguments{
\item{by}{\code{NULL} or character string with any combination of \code{g} (Gender) or
\code{r} (Race), i.e. if you want to retrieve
unemployment data by gender and race, you would set this parameter to "\code{gr}".}
}
\value{
\code{tbl_df} with data filtered by the selected criteria.
}
\description{
The 95–50 and 50–10 wage ratios are representations of the level of inequality within
the hourly wage distribution. The larger the ratio, the greater the gap between the
top and the middle or the middle and the bottom of the wage distribution.
}
\details{
\itemize{
\item{A 50–10 wage ratio of 1.91 means that workers at the 50th percentile of the wage
      distribution are paid 1.91 times more per hour than the workers at the 10th percentile.}
\item{A 95–50 wage ratio of 3.28 means that workers at the 95th percentile of the wage
      distribution are paid 3.28 times more per hour than the workers at the 50th percentile.}
}
}
\examples{
\dontrun{
get_wage_ratios()

get_wage_ratios("r")

get_wage_ratios("gr")
}
}
\references{
\href{http://www.epi.org/data/}{Economic Policy Institute Data Library}
}
