% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_breaks.R
\name{find_breaks}
\alias{find_breaks}
\title{Automatically calculate breaks for a number}
\usage{
find_breaks(n, breaks = 4, snap = 1, ceiling = FALSE)
}
\arguments{
\item{n}{a number to calcluate breaks for}

\item{breaks}{the maximum number of segements you want to have}

\item{snap}{the number defining where to snap to the nearest factor}

\item{ceiling}{if \code{TRUE}, n is included in the breaks}
}
\value{
a vector of integers
}
\description{
Automatically calculate breaks for a number
}
\examples{

# find four breaks from 1 to 100
find_breaks(100)

# find four breaks from 1 to 123, rounding to the nearest 20
find_breaks(123, snap = 20)

# note that there are only three breaks here because of the rounding
find_breaks(123, snap = 25)

# Include the value itself
find_breaks(123, snap = 25, ceiling = TRUE)
}
