% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapcomp.R
\name{mapcomp}
\alias{mapcomp}
\alias{mapcomp.data.frame}
\alias{mapcomp.matrix}
\alias{mapcomp.count}
\alias{mapcomp.incidence}
\title{Map Comparison procedure.}
\usage{
mapcomp(data, ...)

\method{mapcomp}{data.frame}(data, delta, bandwidth, nperm = 100,
  edge_correction = FALSE, threads = 1, verbose = TRUE, ...)

\method{mapcomp}{matrix}(data, delta, bandwidth, nperm = 100,
  edge_correction = FALSE, threads = 1, verbose = TRUE, ...)

\method{mapcomp}{count}(data, delta, bandwidth, nperm = 100,
  edge_correction = FALSE, threads = 1, verbose = TRUE, ...)

\method{mapcomp}{incidence}(data, delta, bandwidth, nperm = 100,
  edge_correction = FALSE, threads = 1, verbose = TRUE, ...)
}
\arguments{
\item{data}{A data frame or a matrix with only three columns: the two first
ones must be the x and y coordinates of the sampling units, and the last
one, the corresponding disease intensity observations. It can also be a
\code{\link{count}} or an \code{\link{incidence}} object.}

\item{...}{Additional arguments to be passed to other methods.}

\item{delta}{Mesh size of the grid over the geographical domain of the
sampling units used to compute the integral Hellinger distance between
the probability density function of observations and the probability
density function of sampling effort.}

\item{bandwidth}{Bandwidth parameter for smoothing. It allows to test the
spatial extent of heterogeneity if any.}

\item{nperm}{Number of random permutations to assess probabilities.}

\item{edge_correction}{Apply edge correction to account for the fact that
bordering points intrinsically suffer from a lack of neighboring
observation sites. FALSE by default.}

\item{threads}{Number of threads to perform the computations.}

\item{verbose}{Explain what is being done (TRUE by default).}
}
\description{
\code{mapcomp} performs a spatial pattern analysis based on the calculation
of a formal distance (the Hellinger distance) between the density map of
count or incidence data, and the density map of sampling effort. Statistical
tests of spatial homogeneity are based on permutations across sampling sites
and on valuable properties of the Hellinger distance.
}
\examples{
set.seed(123)
my_res <- mapcomp(codling_moths, delta = 1, bandwidth = 11,
                  edge_correction = FALSE, nperm = 20)
my_res
plot(my_res)

set.seed(123)
my_count <- count(codling_moths, mapping(x = xm, y = ym))
my_res <- mapcomp(my_count, delta = 1, bandwidth = 11,
                  edge_correction = FALSE, nperm = 20)
my_res
plot(my_res, bins = 10)

}
\references{
Lavigne C, Ricci B, Franck P, Senoussi R. 2010. Spatial analyses of
ecological count data: A density map comparison approach. Basic and Applied
Ecology. 11:734–742.
}
