% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\docType{class}
\name{ParametricJob}
\alias{ParametricJob}
\title{Create and Run Parametric Analysis, and Collect Results}
\description{
\code{ParametricJob} class provides a prototype of conducting parametric analysis
of EnergyPlus simulations.
}
\details{
Basically, it is a collection of multiple \code{EplusJob} objects. However, the
model is first parsed and the \link{Idf} object is stored internally, instead of
storing only the path of Idf like in \link{EplusJob} class. Also, an object in
\code{Output:SQLite} with \verb{Option Type} value of \code{SimpleAndTabular} will be
automatically created if it does not exists, like \link{Idf} class does.
}
\examples{

## ------------------------------------------------
## Method `ParametricJob$new`
## ------------------------------------------------

\dontrun{
if (is_avail_eplus(8.8)) {
    idf_name <- "1ZoneUncontrolled.idf"
    epw_name <-  "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw"

    idf_path <- file.path(eplus_config(8.8)$dir, "ExampleFiles", idf_name)
    epw_path <- file.path(eplus_config(8.8)$dir, "WeatherData", epw_name)

    # create from an Idf and an Epw object
    param <- ParametricJob$new(idf_path, epw_path)
}
}


## ------------------------------------------------
## Method `ParametricJob$version`
## ------------------------------------------------

\dontrun{
param$version()
}


## ------------------------------------------------
## Method `ParametricJob$seed`
## ------------------------------------------------

\dontrun{
param$seed()
}


## ------------------------------------------------
## Method `ParametricJob$weather`
## ------------------------------------------------

\dontrun{
param$weather()
}


## ------------------------------------------------
## Method `ParametricJob$models`
## ------------------------------------------------

\dontrun{
param$models()
}


## ------------------------------------------------
## Method `ParametricJob$apply_measure`
## ------------------------------------------------

\dontrun{
# create a measure to change the orientation of the building
rotate_building <- function (idf, degree = 0L) {
    if (!idf$is_valid_class("Building")) {
       stop("Input model does not have a Building object")
    }

    if (degree > 360 || degree < -360 ) {
        stop("Input degree should in range [-360, 360]")
    }

    cur <- idf$Building$North_Axis

    new <- cur + degree

    if (new > 360) {
        new <- new \%\% 360
        warning("Calculated new north axis is greater than 360. ",
            "Final north axis will be ", new
        )
    } else if (new < -360) {
        new <- new \%\% -360
        warning("Calculated new north axis is smaller than -360. ",
            "Final north axis will be ", new
        )
    }

    idf$Building$North_Axis <- new

    idf
}

# apply measure
# this will create 12 models
param$apply_measure(rotate_building, degree = seq(30, 360, 30))

# apply measure with new names specified
param$apply_measure(rotate_building, degree = seq(30, 360, 30),
    .names = paste0("rotate_", seq(30, 360, 30))
)
}


## ------------------------------------------------
## Method `ParametricJob$save`
## ------------------------------------------------

\dontrun{
# save all parametric models with each model in a separate folder
param$save(tempdir())

# save all parametric models with all models in the same folder
param$save(tempdir(), separate = FALSE)
}


## ------------------------------------------------
## Method `ParametricJob$run`
## ------------------------------------------------

\dontrun{
# run parametric simulations
param$run(wait = TRUE, echo = FALSE)

# run in background
param$run(wait = FALSE)
# get detailed job status by printing
print(param)
}


## ------------------------------------------------
## Method `ParametricJob$print`
## ------------------------------------------------

\dontrun{
param$print()

Sys.sleep(10)
param$print()
}

}
\author{
Hongyuan Jia
}
\section{Super class}{
\code{\link[eplusr:EplusGroupJob]{eplusr::EplusGroupJob}} -> \code{ParametricJob}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ParametricJob$new()}}
\item \href{#method-version}{\code{ParametricJob$version()}}
\item \href{#method-seed}{\code{ParametricJob$seed()}}
\item \href{#method-weather}{\code{ParametricJob$weather()}}
\item \href{#method-models}{\code{ParametricJob$models()}}
\item \href{#method-apply_measure}{\code{ParametricJob$apply_measure()}}
\item \href{#method-save}{\code{ParametricJob$save()}}
\item \href{#method-run}{\code{ParametricJob$run()}}
\item \href{#method-print}{\code{ParametricJob$print()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="errors">}\href{../../eplusr/html/EplusGroupJob.html#method-errors}{\code{eplusr::EplusGroupJob$errors()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="kill">}\href{../../eplusr/html/EplusGroupJob.html#method-kill}{\code{eplusr::EplusGroupJob$kill()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="list_table">}\href{../../eplusr/html/EplusGroupJob.html#method-list_table}{\code{eplusr::EplusGroupJob$list_table()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="locate_output">}\href{../../eplusr/html/EplusGroupJob.html#method-locate_output}{\code{eplusr::EplusGroupJob$locate_output()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="output_dir">}\href{../../eplusr/html/EplusGroupJob.html#method-output_dir}{\code{eplusr::EplusGroupJob$output_dir()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="read_mdd">}\href{../../eplusr/html/EplusGroupJob.html#method-read_mdd}{\code{eplusr::EplusGroupJob$read_mdd()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="read_rdd">}\href{../../eplusr/html/EplusGroupJob.html#method-read_rdd}{\code{eplusr::EplusGroupJob$read_rdd()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="read_table">}\href{../../eplusr/html/EplusGroupJob.html#method-read_table}{\code{eplusr::EplusGroupJob$read_table()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="report_data">}\href{../../eplusr/html/EplusGroupJob.html#method-report_data}{\code{eplusr::EplusGroupJob$report_data()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="report_data_dict">}\href{../../eplusr/html/EplusGroupJob.html#method-report_data_dict}{\code{eplusr::EplusGroupJob$report_data_dict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="status">}\href{../../eplusr/html/EplusGroupJob.html#method-status}{\code{eplusr::EplusGroupJob$status()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="tabular_data">}\href{../../eplusr/html/EplusGroupJob.html#method-tabular_data}{\code{eplusr::EplusGroupJob$tabular_data()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a \code{ParametricJob} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$new(idf, epw)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{idf}}{Path to EnergyPlus IDF file or an \code{Idf} object.}

\item{\code{epw}}{Path to EnergyPlus EPW file or an \code{Epw} object. \code{epw} can
also be \code{NULL} which will force design-day-only simulation
when \verb{$run()} method is called. Note this needs at least one
\code{Sizing:DesignDay} object exists in the \link{Idf}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{ParametricJob} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
if (is_avail_eplus(8.8)) {
    idf_name <- "1ZoneUncontrolled.idf"
    epw_name <-  "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw"

    idf_path <- file.path(eplus_config(8.8)$dir, "ExampleFiles", idf_name)
    epw_path <- file.path(eplus_config(8.8)$dir, "WeatherData", epw_name)

    # create from an Idf and an Epw object
    param <- ParametricJob$new(idf_path, epw_path)
}
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-version"></a>}}
\subsection{Method \code{version()}}{
Get the version of seed IDF
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$version()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$version()} returns the version of input seed \link{Idf} object.
}

\subsection{Returns}{
A \code{\link[base:numeric_version]{base::numeric_version()}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
param$version()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-seed"></a>}}
\subsection{Method \code{seed()}}{
Get the seed \link{Idf} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$seed()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$seed()} returns the parsed input seed \link{Idf} object.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
param$seed()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-weather"></a>}}
\subsection{Method \code{weather()}}{
Get the \link{Epw} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$weather()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$weather()} returns the input \link{Epw} object. If no \link{Epw} is provided
when creating the \code{ParametricJob} object, \code{NULL} is returned.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
param$weather()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-models"></a>}}
\subsection{Method \code{models()}}{
Get created parametric \link{Idf} objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$models()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$models()} returns a list of parametric models generated using input
\link{Idf} object and
\href{../../eplusr/html/ParametricJob.html#method-apply_measure}{\code{$apply_measure()}}
method. Model names are assigned in the same way as the \code{.names}
arugment in
\href{../../eplusr/html/ParametricJob.html#method-apply_measure}{\code{$apply_measure()}}.
If no measure has been applied, \code{NULL} is returned. Note that it is
not recommended to conduct any extra modification on those models
directly, after they were created using
\href{../../eplusr/html/ParametricJob.html#method-apply_measure}{\code{$apply_measure()}},
as this may lead to an un-reproducible process. A warning message
will be issued if any of those models has been modified when running
simulations.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
param$models()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-apply_measure"></a>}}
\subsection{Method \code{apply_measure()}}{
Create parametric models
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$apply_measure(measure, ..., .names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measure}}{A function that takes an \code{Idf} and other arguments as
input and returns an \link{Idf} object as output.}

\item{\code{...}}{Arguments \strong{except first \code{Idf} argument} that are passed
to that \code{measure}.}

\item{\code{.names}}{A character vector of the names of parametric \code{Idf}s.
If \code{NULL}, the new \code{Idf}s will be named in format
\code{measure_name + number}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$apply_measure()} allows to apply a measure to an \link{Idf} and creates
parametric models for analysis. Basically, a measure is just a
function that takes an \link{Idf} object and other arguments as input, and
returns a modified \link{Idf} object as output. Use \code{...} to supply
different arguments, \strong{except for the first \code{Idf} argument}, to that
measure. Under the hook, \code{\link[base:mapply]{base::mapply()}} is used to create multiple
\link{Idf}s according to the input values.
}

\subsection{Returns}{
The modified \code{ParametricJob} object itself, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# create a measure to change the orientation of the building
rotate_building <- function (idf, degree = 0L) {
    if (!idf$is_valid_class("Building")) {
       stop("Input model does not have a Building object")
    }

    if (degree > 360 || degree < -360 ) {
        stop("Input degree should in range [-360, 360]")
    }

    cur <- idf$Building$North_Axis

    new <- cur + degree

    if (new > 360) {
        new <- new \%\% 360
        warning("Calculated new north axis is greater than 360. ",
            "Final north axis will be ", new
        )
    } else if (new < -360) {
        new <- new \%\% -360
        warning("Calculated new north axis is smaller than -360. ",
            "Final north axis will be ", new
        )
    }

    idf$Building$North_Axis <- new

    idf
}

# apply measure
# this will create 12 models
param$apply_measure(rotate_building, degree = seq(30, 360, 30))

# apply measure with new names specified
param$apply_measure(rotate_building, degree = seq(30, 360, 30),
    .names = paste0("rotate_", seq(30, 360, 30))
)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save"></a>}}
\subsection{Method \code{save()}}{
Save parametric models
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$save(dir = NULL, separate = TRUE, copy_external = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{The parent output directory for models to be saved. If
\code{NULL}, the directory of the seed model will be used. Default:
\code{NULL}.}

\item{\code{separate}}{If \code{TRUE}, all models are saved in a separate folder
with each model's name under specified directory. If \code{FALSE},
all models are saved in the specified directory. Default:
\code{TRUE}.}

\item{\code{copy_external}}{Only applicable when \code{separate} is \code{TRUE}. If
\code{TRUE}, the external files that every \code{Idf} object depends on
will also be copied into the saving directory. The values of
file paths in the Idf will be changed automatically.
Currently, only \code{Schedule:File} class is supported.  This
ensures that the output directory will have all files needed
for the model to run. Default: \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$save()} saves all parametric models in specified folder. An error
will be issued if no measure has been applied.
}

\subsection{Returns}{
A \code{\link[data.table:data.table]{data.table::data.table()}} with two columns:
\itemize{
\item model: The path of saved parametric model files.
\item weather: The path of saved weather files.
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# save all parametric models with each model in a separate folder
param$save(tempdir())

# save all parametric models with all models in the same folder
param$save(tempdir(), separate = FALSE)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\subsection{Method \code{run()}}{
Run parametric simulations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$run(
  dir = NULL,
  wait = TRUE,
  force = FALSE,
  copy_external = FALSE,
  echo = wait
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{The parent output directory for specified simulations.
Outputs of each simulation are placed in a separate folder
under the parent directory.}

\item{\code{wait}}{If \code{TRUE}, R will hang on and wait all EnergyPlus
simulations finish. If \code{FALSE}, all EnergyPlus simulations are
run in the background.  Default: \code{TRUE}.}

\item{\code{force}}{Only applicable when the last simulation runs with
\code{wait} equals to \code{FALSE} and is still running. If \code{TRUE},
current running job is forced to stop and a new one will
start. Default: \code{FALSE}.}

\item{\code{copy_external}}{If \code{TRUE}, the external files that current \code{Idf}
object depends on will also be copied into the simulation
output directory. The values of file paths in the Idf will be
changed automatically. Currently, only \code{Schedule:File} class
is supported.  This ensures that the output directory will
have all files needed for the model to run. Default is
\code{FALSE}.}

\item{\code{echo}}{Only applicable when \code{wait} is \code{TRUE}. Whether to
simulation status. Default: same as \code{wait}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$run()} runs all parametric simulations in parallel. The number of
parallel EnergyPlus process can be controlled by
\code{eplusr_option("num_parallel")}. If \code{wait} is FALSE, then the job
will be run in the background. You can get updated job status by just
printing the \code{ParametricJob} object.
}

\subsection{Returns}{
The \code{ParametricJob} object itself, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# run parametric simulations
param$run(wait = TRUE, echo = FALSE)

# run in background
param$run(wait = FALSE)
# get detailed job status by printing
print(param)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
Print \code{ParametricJob} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$print()} shows the core information of this \code{ParametricJob},
including the path of IDFs and EPWs and also the simulation job
status.

\verb{$print()} is quite useful to get the simulation status, especially
when \code{wait} is \code{FALSE} in \verb{$run()}. The job status will be updated
and printed whenever \verb{$print()} is called.
}

\subsection{Returns}{
The \code{ParametricJob} object itself, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
param$print()

Sys.sleep(10)
param$print()
}

}
\if{html}{\out{</div>}}

}

}
}
