% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processATC.R
\name{filterApprovedDrugs}
\alias{filterApprovedDrugs}
\title{Filter a given list of drug names for having an ATC code, if not they are dropped}
\usage{
filterApprovedDrugs(druglist, atchashda)
}
\arguments{
\item{druglist}{a list of drug names}

\item{atchashda}{a hash containing the drug names as keys}
}
\value{
approveddrugs a hash filtered for having an ATC code
}
\description{
Filter a given list of drug names for having an ATC code, if not they are dropped
}
\examples{
utils::data(rawDrugBankCoOcEpSO, package="epos")
atchashda <-
  readAtcMapIntoHashMapDrugNamesAtcCodes(
  system.file("extdata", "db-atc.map", package = "epos"), "\\t")
tepso <- genDictListFromRawFreq(rawDrugBankCoOcEpSO)
filterApprovedDrugs(tepso, atchashda)
}
