% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epoxy_transform_html.R
\name{epoxy_transform_html}
\alias{epoxy_transform_html}
\title{Concise syntax for expressions inside HTML elements}
\usage{
epoxy_transform_html(
  class = NULL,
  element = "span",
  transformer = glue::identity_transformer
)
}
\arguments{
\item{class}{\verb{[character()]}\cr Additional classes to be added to the inline
HTML element.}

\item{element}{\verb{[character()}\cr The default HTML element tag name to be used
when an element isn't specified in the expression.}

\item{transformer}{The transformer to apply to the replacement string. This
argument is used for chaining the transformer functions. By providing a
function to this argument you can apply an additional transformation after
the current transformation. In nearly all cases, you can let
\code{epoxy_transform()} handle this for you. The chain ends when
\code{\link[glue:identity_transformer]{glue::identity_transformer()}} is used as the \code{transformer}.}
}
\value{
A function of \code{text} and \code{envir} suitable for the \code{.transformer} argument of
\code{\link[glue:glue]{glue::glue()}}.
}
\description{
\code{epoxy_transform_html()} provides a
\href{https://pughtml.com/what-is-pug-html}{pug}-like syntax for expressions in
HTML that are wrapped in HTML elements.
\subsection{Syntax}{

You can specify the HTML element and its \code{id} and \code{class} into which the
text of the expression will be placed. The template is to specify the element
using the syntax below, followed by the R expression, separated by a space:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{\{ [<element>][#<id> | .<class>...] expr \}\}
}\if{html}{\out{</div>}}

For example, to place the expression in a \verb{<li>} element with \code{id = "food"}
and \code{class = "fruit"}, you could write

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{\{ li#food.fruit fruit_name \}\}
}\if{html}{\out{</div>}}

Each item in the HTML template is optional:
\enumerate{
\item If a specific HTML element is desired, the element name must be first. If
no element is specified, the default as set by the \code{element} argument of
\code{\link[=epoxy_transform_html]{epoxy_transform_html()}} will be used.
\item IDs are specified using \verb{#<id>} and only one ID may be present
\item Classes are written using \verb{.<class>} and as many classes as desired are
allowed.
}

If the expression is a vector, the same element container will be used for
each item in the vector.

Finally, if the expression returns HTML, it will be escaped by default. You
can either use \code{\link[htmltools:HTML]{htmltools::HTML()}} to mark it as safe HTML in R, or you can
write \code{!!expr} in the inline markup: \verb{\{\{ li#food.fruit !!fruit_name \}\}}.
}
}
\examples{
epoxy_html("<ul>{{ li letters[1:3] }}</ul>")
epoxy_html("<ul>{{ li.alpha letters[1:3] }}</ul>")
epoxy_html("<ul>{{ li#my-letter letters[7] }}</ul>")

# The default element is used if no element is directly requested
epoxy_html("My name starts with {{ .name-letter letters[7] }}")

epoxy_html(
	"{{ h3#title title }}",
	title = "Epoxy for HTML"
)

# If your replacement text contains HTML, it's escaped by default.
hello <- "<strong>Hi there!</strong>"
epoxy_html("{{ hello }}")

# You can use !! inline to mark the text as safe HTML...
epoxy_html("{{ !!hello }}")
epoxy_html("{{ button !!hello }}")

# ...or you can use htmltools::HTML() to mark it as safe HTML in R.
hello <- htmltools::HTML("<strong>Hi there!</strong>")
epoxy_html("{{ hello }}")

}
\seealso{
Used by default in \code{\link[=epoxy_html]{epoxy_html()}}

Other epoxy's glue transformers: 
\code{\link{epoxy_transform_inline}()},
\code{\link{epoxy_transform}()}
}
\concept{epoxy's glue transformers}
