% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph.R
\name{morphing_epw}
\alias{morphing_epw}
\title{Morphing EPW weather variables}
\usage{
morphing_epw(
  data,
  years = NULL,
  labels = NULL,
  methods = NULL,
  warning = FALSE
)
}
\arguments{
\item{data}{An \code{epw_cmip6_data}object generated using \code{\link[=extract_data]{extract_data()}}}

\item{years}{An integer vector indicating the target years to be considered.
If \code{NULL}, all years in input data will be considered. Default: \code{NULL}.}

\item{labels}{A character or factor vector used for grouping input \code{years}.
Usually are the outputs of \code{\link[base:cut]{base::cut()}}. \code{labels} should have the
same length as \code{years}. If given, climate data of \code{years} grouped by
\code{labels} will be averaged. Default: \code{NULL}.}

\item{methods}{A named character giving the methods of morphing procedures of
each variables. Possible variable names are \code{tdb}, \code{rh}, \code{p},
\code{hor_ir}, \code{glob_rad}, \code{wind}. Possible values are: \code{"stretch"},
\code{"shift"} and \code{"combined"}. For example: \code{c(tdb = "stretch", rh = "shift")}. \code{"combined"} is only applicable to \code{tdb}. The default
morphing method for each variable is listed in the \emph{Return} section.
If \code{NULL}, the default methods will be used. Default: \code{NULL}.}

\item{warning}{If \code{TRUE}, warnings will be issued for cases with input data
less than a decade (10 years). This is because using data that only
covers a short period of time may not be able to capture the average
of future climate. Default: \code{FALSE}.}
}
\value{
An \code{epw_cmip6_morphed} object, which is basically a list of 12 elements:\tabular{rllll}{
   No. \tab Element \tab Type \tab Morphing Method \tab Description \cr
   1 \tab \code{epw} \tab \link[eplusr:Epw]{eplusr::Epw} \tab N/A \tab The original EPW file used for morphing \cr
   2 \tab \code{tdb} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of dry-bulb temperature after morphing \cr
   3 \tab \code{tdew} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Derived \tab Data of dew-point temperature after morphing \cr
   4 \tab \code{rh} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of relative humidity after morphing \cr
   5 \tab \code{p} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of atmospheric pressure after morphing \cr
   6 \tab \code{hor_ir} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of horizontal infrared radiation from the sky after morphing \cr
   7 \tab \code{glob_rad} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of global horizontal radiation after morphing \cr
   8 \tab \code{norm_rad} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Derived \tab Data of direct normal radiation after morphing \cr
   9 \tab \code{diff_rad} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of diffuse horizontal radiation after morphing \cr
   10 \tab \code{wind} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of wind speed after morphing \cr
   11 \tab \code{total_cover} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Derived \tab Data of total sky cover after morphing \cr
   12 \tab \code{opaque_cover} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Derived \tab Data of opaque sky cover after morphing \cr
}


Each \code{\link[data.table:data.table]{data.table::data.table()}} listed above contains 19 columns below or an
empty \code{\link[data.table:data.table]{data.table::data.table()}} if the corresponding variables cannot be
found in the input \code{epw_cmip6_data} object.\tabular{rlll}{
   No. \tab Column \tab Type \tab Description \cr
   1 \tab \code{activity_drs} \tab Character \tab Activity DRS (Data Reference Syntax) \cr
   2 \tab \code{institution_id} \tab Character \tab Institution identifier \cr
   3 \tab \code{source_id} \tab Character \tab Model identifier \cr
   4 \tab \code{experiment_id} \tab Character \tab Root experiment identifier \cr
   5 \tab \code{member_id} \tab Character \tab A compound construction from \code{sub_experiment_id} and \code{variant_label} \cr
   6 \tab \code{table_id} \tab Character \tab Table identifier \cr
   7 \tab \code{lon} \tab Double \tab The \strong{averaged} values of input longitude \cr
   8 \tab \code{lat} \tab Double \tab The \strong{averaged} values of input latitude \cr
   9 \tab \code{dist} \tab Double \tab The \strong{averaged} spherical distances in km between EPW location and grid coordinates \cr
   10 \tab \code{interval} \tab Factor \tab The label value used to average raw input data \cr
   11 \tab \code{datetime} \tab POSIXct \tab The datetime value with \strong{fake year} generated by calling the \code{Epw$data()} method with the input EPW \cr
   12 \tab \code{year} \tab Integer \tab The \strong{original} year of the raw EPW data \cr
   13 \tab \code{month} \tab Integer \tab The month value of the morphed data \cr
   14 \tab \code{day} \tab Integer \tab The day of the morphed data \cr
   15 \tab \code{hour} \tab Integer \tab The hour of the morphed data \cr
   16 \tab \code{minute} \tab Integer \tab The minute of the morphed data \cr
   17 \tab \strong{Variable Name} \tab Double \tab The morphed data, where \verb{Variable Name} is the corresponding EPW weather variable name \cr
   18 \tab \code{delta} \tab Double \tab The shift factor. Will be \code{NA} for derived values \cr
   19 \tab \code{alpha} \tab Double \tab The stretch factor. Will be \code{NA} for derived values \cr
}
}
\description{
\code{morphing_epw()} takes an \code{epw_cmip6_data} object generated using
\code{\link[=extract_data]{extract_data()}} and calculates future core EPW weather variables using
Morphing Method.
}
\details{
The EPW weather variables that get morphed are listed in details.
}
\section{The Morphing procedure}{
Here \emph{Morphing} is an algorithm proposed by Belcher etc. 2005
used to morph the present-day observed weather files (here the EPWs)  to
produce future climate weather files. The EPW data is used as the
\emph{'baseline climate'}.

The first step before morphing is to calculate the monthly means of
climatological variables in the EPW file, denoted by \eqn{<x_0>_m}.
The subscript '0' is to denote the present day weather record, and 'm' is to
denote the month.

The morphing involves three generic operations, i.e. 1) a shift; 2) a linear
stretch (scaling factor); and 3) a shift and a stretch:

\deqn{
\textrm{Shift: } x = x_0 + \Delta x_m
}

\deqn{
\textrm{Stretch: }x = \alpha_m x_m
}

\deqn{
\textrm{Shift + Stretch: } x = x_0 + \Delta x_m + \alpha_m (x_0 - <x_0>_m)
}
\subsection{Shift}{

If using a shift, for each month, a shift \eqn{\Delta x_m} is applied to
\eqn{x_0}. \eqn{\Delta x_m} is the absolute change in the monthly mean value
of the variable for the month \eqn{m},
i.e. \eqn{\Delta x_m = <x_0>_m - <x>_m}. Here the monthly variance of the
variable is unchanged.
}

\subsection{Stretch}{

If using a stretch, for each month, a stretch \eqn{\alpha _m} is applied to
\eqn{x_0}, where \eqn{\alpha _m} is the fractional change in the monthly-mean
value of a variable, i.e. \eqn{\alpha _m = <x>_m / <x_0>_m}. In this case,
the variance will be multiplied by to \eqn{\alpha^2_m}
}

\subsection{Combined Shift and Stretch}{

When using a combined shift and stretch factor, both the mean and the
variance will be switched off altogether.

For more details about morphing, please see (Belcher etc. 2005)
}
}

\references{
Belcher, S., Hacker, J., Powell, D., 2005. Constructing design weather data
for future climates. Building Services Engineering Research and Technology
26, 49–61. https://doi.org/10.1191/0143624405bt112oa
}
