% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqpchc.R
\name{pchc}
\alias{pchc}
\title{Calculate the Paretian Classification of Health Change}
\usage{
pchc(
  pre,
  post,
  version = NULL,
  no.problems = TRUE,
  totals = TRUE,
  by.dimension = FALSE,
  ignore.invalid = TRUE,
  dimensions = .get_dimension_names(),
  summary = TRUE
)
}
\arguments{
\item{pre}{data.frame, numeric or character. For data.frame default column 
names should be MO, SC, UA, PD and AD representing Mobility, Self-care, 
Usual activities, Pain/discomfort and Anxiety/depression. Vector using five 
digit format can also be used.}

\item{post}{data.frame, numeric or character. For data.frame default column 
names should be MO, SC, UA, PD and AD representing Mobility, Self-care, 
Usual activities, Pain/discomfort and Anxiety/depression. Vector using five 
digit format can also be used.}

\item{version}{string of value "3L" or "5L" to indicate instrument version.}

\item{no.problems}{boolean. Summarise 11111 "No change" subjects in a "No problems" 
group.}

\item{totals}{boolean. Include a summary total.}

\item{by.dimension}{boolean. Summarise results by each EQ-5D dimension rather 
than by the whole dataset.}

\item{ignore.invalid}{boolean whether to ignore invalid scores. TRUE returns NA, FALSE 
throws an error.}

\item{dimensions}{character vector, specifying "dimension" column names. Defaults 
are "MO", "SC", "UA", "PD" and "AD".}

\item{summary}{boolean. Summarise results or return all classifications.}
}
\value{
a data.frame or list of data.frames of changes according to PCHC.
contain dimensions names and rows the EQ-5D score or, if summary=FALSE, a vector or  
list of vectors of changes.
}
\description{
Calculate the Paretian Classification of Health Change (PCHC) for two EQ-5D datasets.
}
\examples{
dat <- read.csv(system.file("extdata", "eq5d3l_example.csv", package="eq5d"))

pre <- dat[dat$Group=="Group1",][1:50,]
post <- dat[dat$Group=="Group2",][1:50,]

pchc(pre, post, version="3L", no.problems=FALSE, totals=FALSE)

}
