\name{genoplot}
\alias{genoplot}
\title{Genome plot of the eQTL data on the expression traits locations}

\description{
Plot the estimated eQTL positions with the genomic positions of the controlled gene.
}

\usage{
genoplot( peak.array, cross, etrait.coord, data.gmap, chr.size, save.pict=FALSE, ...)
}

\arguments{
\item{cross}{ An object of class \code{cross}. See 'qtl' package manual for \code{read.cross} function details.}
\item{peak.array}{ An object of class \code{peak.array}. See \code{peak.2.array} function for details.}
\item{etrait.coord}{ A data frame specifying the etrait genomic locations with colums:\cr
	\code{etrait.name} a factor with  array element or gene name as levels.\cr
	\code{chr} an integer vector determining the chromosome.\cr
	\code{start} an integer vector determining the GST start location in base pair.\cr
	\code{stop} an integer vector determining the GST stop location in base pair.
}
\item{data.gmap}{ A data frame with column names \code{"Marker"}, \code{"chr"} and \code{"PP"} specifying the marker physical locations. Those one must be the same markers defined in the related \code{cross} object.
	\code{data.gmap$Marker} is a vector character strings specifying the names of markers.\cr
	\code{data.gmap$chr} is a vector of integers specifying the chromosome on which the markers are localized.\cr
	\code{data.gmap$PP} is a vector of integers specifying the physical marker location on the chromosome in base pair.
}
\item{chr.size}{A vector of integer specifying the size of the chromosomes in base pair in order of the chromosomes.}
\item{save.pict}{If TRUE, save each charts generated by \code{genoplot} as png files in the current folder.}
\item{...}{Ignored at this step.}
}

\details{
Useful for genetical genomics studies. This function gives a graphical overview of the global eQTL network by plotting the estimated eQTL positions with the genomic positions of the affected traits. Six charts are generated and all locations data are represented on a physical scale. The genomic ditribution of the affected traits and the QTLs genomic distribution are described by two histograms. If \code{save.pict=TRUE}, these histograms are saved as \code{./histogram_controled_gst.png} and \code{./histogram_qtl.png} files, respectively. The etrait~eQTL plot are represented with LOD color scale (from green to red in order of increasing LOD score) and with additive effect color scale (from green to red in order of increasing additive effect, yellow representing the null additive effect). Four etrait~eQTL plot are generated representing the eQTL locations as single LOD peaks or support interval regions, both with LOD and additive effect color scales. If \code{save.pict=TRUE}, these plot are saved as \code{"lod_dotplot_traitxqtl.png"}, \code{"ae_dotplot_traitxqtl.png"}, \code{"lod_siplot_traitxqtl.png"} and \code{"ae_siplot_traitxqtl.png"} files.
}

\value{
return a list with elements:
\item{coord_etrait}{the etrait coordinates.}
\item{coord_qtl}{the QTL coordinates.}
\item{limit}{the chromosomes limits.}
\item{add_etrait}{the cumulates size of the chromosomes in bp for the etrait.}
\item{add_qtl}{the cumulates size of of the chromosomes in bp for the QTL.}
}

\author{ Hamid A. Khalili }

\seealso{ \code{\link{define.peak}},\code{\link[qtl]{read.cross}}}

\examples{
data(seed10);

seed10 <- calc.genoprob( cross=seed10, step=2, off.end=0, error.prob=0,
	 map.function='kosambi', stepwidth='fixed');
seed10 <- sim.geno( cross=seed10, step=2, off.end=0, error.prob=0,
	 map.function='kosambi', stepwidth='fixed');

out.em <- scanone( seed10, pheno.col=1:50, model='normal', method='em');
out.peak <- define.peak( out.em, 'all');
out.peak <- calc.adef(seed10,out.em,out.peak);

data(BSpgmap);
data(ATH.coord);

out.peak <- localize.qtl(seed10, out.peak, BSpgmap);
out.array <- peak.2.array(out.peak)

genoplot(out.array, seed10, ATH.coord, BSpgmap,
	 chr.size=c(30432457,19704536,23470536,18584924,26991304), save.pict=TRUE);
# NB: the size of the Arabidopsis thaliana chromosomes are
# 30432457, 19704536, 23470536, 18584924 and 26991304 total base pairs
# for chromosomes 1 to 5 respectively
}
\keyword{hplot}

