% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoF.R
\name{GoF}
\alias{GoF}
\title{Conduct Goodness-of-Fit Diagnostics for a Signed ERGM}
\usage{
GoF(model, nsim = 200, seed = NULL)
}
\arguments{
\item{model}{A fitted signed ERGM (SERGM) object.}

\item{nsim}{Integer; number of simulated networks to generate. Defaults to 200.}

\item{seed}{Optional integer seed for reproducibility. Passed to
\code{\link{set.seed}}.}
}
\value{
Produces six diagnostic boxplots comparing observed and simulated
  statistics for the fitted model.
}
\description{
Computes the goodness-of-fit (GoF) for a fitted signed exponential random
graph model (SERGM). The function simulates new networks using the fitted
model and compares key network statistics from the observed network with
those from the simulated ones.
}
\details{
The following diagnostics are plotted:
\itemize{
  \item Positive degree distribution
  \item Negative degree distribution
  \item Edgewise shared enemies distribution (positive edges)
  \item Edgewise shared enemies distribution (negative edges)
  \item Edgewise shared friends distribution (positive edges)
  \item Edgewise shared friends distribution (negative edges)
}
}
\examples{
\donttest{
data("tribes")
fit <- mple_sign(tribes ~ Pos(~edges) + Neg(~edges))
GoF(fit, nsim = 100)
}

}
\seealso{
\code{\link[ergm]{ergm}}, \code{\link{mple_sign}}
}
