% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmConstraint.R
\name{blocks-ergmConstraint}
\alias{blocks-ergmConstraint}
\alias{InitErgmConstraint.blocks}
\title{Constrain blocks of dyads defined by mixing type on a vertex attribute.}
\usage{
# blocks(attr=NULL, levels=NULL, levels2=FALSE, b1levels=NULL, b2levels=NULL)
}
\arguments{
\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{b1levels, b2levels, levels, level2}{control what mixing types are fixed.
\code{levels2} applies to all networks; \code{levels} applies to unipartite networks;
\code{b1levels} and \code{b2levels} apply to bipartite networks (see Specifying Vertex
attributes and Levels (\code{?nodal_attributes}) for details)}
}
\description{
Any dyad whose toggle would produce a nonzero change statistic
for a \code{nodemix} term with the same arguments will be fixed. Note
that the \code{levels2} argument has a different default value for
\code{blocks} than it does for \code{nodemix}.
}
\seealso{
\code{\link{ergmConstraint}} for index of constraints and hints currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmConstraint", "blocks", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{undirected}
