% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statement.R
\name{trigger}
\alias{trigger}
\title{Trigger \code{Statement} Object}
\usage{
trigger(statement, as = NULL)
}
\arguments{
\item{statement}{The \code{Statement} object to trigger.}

\item{as}{Optional. \code{"error"}, \code{"warning"} or \code{"message"} which indicates
how to trigger the \code{Statement} object. The default value is \code{"error"}.}
}
\value{
Generate a normal, warning or error message.
}
\description{
Generate a normal, warning or error message with a
\code{Statement} object.
}
\examples{
s <- Statement("general", letters[1:3])

# generate a normal message
trigger(s, "message")

\dontrun{
# generate an error message
trigger(s, "error")
}
}
\seealso{
\code{\link[=Statement]{Statement()}} for creating \code{Statement} objects.

\code{vignette("erify")} for a gentle introduction to this package.
}
