% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{enable_errorist}
\alias{enable_errorist}
\alias{disable_errorist}
\title{Enable or Disable Errorist's Automatic Search}
\usage{
enable_errorist(
  error_search_func = getOption("errorist.warning", searcher::search_google),
  warning_search_func = getOption("errorist.warning", searcher::search_google)
)

disable_errorist()
}
\arguments{
\item{error_search_func}{The search function from \code{\link{searcher}} that should be called when
an error or warning occurs. By default, searches are routed through
\href{https://google.com}{Google}.}

\item{warning_search_func}{The search function from \code{\link{searcher}} that should be called when
an error or warning occurs. By default, searches are routed through
\href{https://google.com}{Google}.}
}
\description{
Activates or disengages the automatic look up of error or warning codes in
\emph{R}.
}
\details{
The \code{enable_errorist()} is automatically called on package start to
inject handlers for warnings and errors. When the package is unloaded,
\code{disable_errorist()} is called to remove warnings and errors. If you
wish to disable warnings or error individually, please use either
\code{\link[=disable_error_shim]{disable_error_shim()}} or \code{\link[=disable_warning_shim]{disable_warning_shim()}}.
}
\examples{

### Default search engine is Google

# Enable automatic search
# NB: This is done automatically on package load.
enable_errorist()

# Some code ...

# Disable automatic search
# NB: This is done automatically on package unload via "detach()"
disable_errorist()

#### Custom search engines

# Enable automatic search with custom search engines
# NB: This is done automatically on package load.
enable_errorist(error_search_func   = searcher::search_bing,
                warning_search_func = searcher::search_duckduckgo)

# Some code ...

# Disable automatic search
# NB: This is done automatically on package unload via "detach()"
disable_errorist()
}
\seealso{
\code{\link[=enable_error_shim]{enable_error_shim()}}, \code{\link[=enable_warning_shim]{enable_warning_shim()}},
\code{\link[=disable_error_shim]{disable_error_shim()}}, \code{\link[=disable_warning_shim]{disable_warning_shim()}}
}
\author{
James Joseph Balamuta
}
