% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{prob_tox_exceeds}
\alias{prob_tox_exceeds}
\title{Probability that the toxicity rate exceeds some threshold.}
\usage{
prob_tox_exceeds(x, threshold, ...)
}
\arguments{
\item{x}{Object of type \code{\link{selector}}}

\item{threshold}{Probability that toxicity rate exceeds what?}

\item{...}{arguments passed to other methods}
}
\value{
numerical vector of probabilities
}
\description{
Get the probability that the toxicity rate at each dose exceeds some
threshold.
}
\examples{
# CRM example
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
outcomes <- '1NNN 2NTN'
fit <- get_dfcrm(skeleton = skeleton, target = target) \%>\% fit(outcomes)
# What is probability that tox rate at each dose exceeds target by >= 10\%?
fit \%>\% prob_tox_exceeds(threshold = target + 0.1)
}
