% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis_evaluation.R
\name{test_rdiff}
\alias{test_rdiff}
\title{Test a hypothesis about a difference in correlation strength}
\usage{
test_rdiff(estimate, rope = c(0, 0), output_html = FALSE)
}
\arguments{
\item{estimate}{\itemize{
\item An esci_estimate object generated by an estimate_rdiff_
function
}}

\item{rope}{\itemize{
\item A two-element vector defining the Region of Practical
Equivalence (ROPE). Specify c(0, 0) to test a point null of exactly 0.
Specify any two ascending values between -1 and 1 to test an interval null
(e.g. c(-.25, .25) to test the hypothesis that the difference in
correlation is between -.25 and .25).
}}

\item{output_html}{\itemize{
\item TRUE to return results in HTML; FALSE (default) to
return standard output
}}
}
\value{
Returns a list with 1-2 data frames
\itemize{
\item \strong{point_null}  - always returned
\itemize{
\item \emph{test_type} - 'Nil hypothesis test', meaning a test against H0 = 0
\item \emph{outcome_variable_name} - Name of the outcome variable
\item \emph{effect} - Label for the effect being tested
\item \emph{null_words} - Express the null in words
\item \emph{confidence} - Confidence level, integer (95 for 95\%, etc.)
\item \emph{LL} - Lower boundary of the confidence\% CI for the effect
\item \emph{UL} - Upper boundary of the confidence\% CI for the effect
\item \emph{CI} - Character representation of the CI for the effect
\item \emph{CI_compare} - Text description of relation between CI and null
\item \emph{t} - If applicable, t value for hypothesis test
\item \emph{df} - If applicable, degrees of freedom for hypothesis test
\item \emph{p} - If applicable, p value for hypothesis test
\item \emph{p_result} - Text representation of p value obtained
\item \emph{null_decision} - Text represention of the decision for the null
\item \emph{conclusion} - Text representation of conclusion to draw
\item \emph{significant} - TRUE/FALSE if significant at alpha = 1-CI
}
\item \strong{interval_null} - returned only if an interval null is specified
\itemize{
\item \emph{test_type} - 'Practical significance test', meaning a test against an
interval null
\item \emph{outcome_variable_name} -
\item \emph{effect} - Name of the outcome variable
\item \emph{rope} - Test representation of null interval
\item \emph{confidence} - Confidence level, integer (95 for 95\%, etc.)
\item \emph{CI} - Character representation of the CI for the effect
\item \emph{rope_compare} - Text description of relation between CI and null interval
\item \emph{p_result} - Text representation of p value obtained
\item \emph{conclusion} - Text representation of conclusion to draw
\item \emph{significant} - TRUE/FALSE if significant at alpha = 1-CI
}
}
}
\description{
\code{test_rdiff} is suitable for testing a hypothesis about a
difference in correlation (\emph{r}) between two conditions.
At the moment, it can only test hypotheses for independent-group designs.
}
\details{
This function can be passed an esci_estimate object generated by
\code{\link[=estimate_rdiff_two]{estimate_rdiff_two()}}.

It can test hypotheses about a specific value for the difference (a
point null) or about a range of values (an interval null)
}
\examples{
# example code
estimate <- esci::estimate_rdiff_two(
  comparison_r = .53,
  comparison_n = 45,
  reference_r = .41,
  reference_n = 59,
  grouping_variable_levels = c("Females", "Males"),
  x_variable_name = "Satisfaction with life",
  y_variable_name = "Body satisfaction",
  grouping_variable_name = "Gender",
  conf_level = .95
)
test_rdiff(estimate)


}
