% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_jd.R
\name{time_jd}
\alias{time_jd}
\title{Convert time string to Julian Day}
\usage{
time_jd(time)
}
\arguments{
\item{time}{\code{Character} value, date to convert to Julian Day. If 
no POSIXct format is provided, the function will try to convert the 
input data to POSIXct, assuming the time zone is UTC.}
}
\value{
\code{Character} value, Julian Day corresponding to the input 
date.
}
\description{
This function converts a POSIXct-like date into the corresponding Julian 
Day number and returns it as string format.
}
\details{
There is also a more powerful function to convert between different time 
formats, see \code{time_convert} for details.
}
\examples{

time_jd(time = "2020-05-01")

}
\author{
Michael Dietze
}
\keyword{eseis}
