% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esFinal.R
\name{esFinal}
\alias{esFinal}
\title{esFinal}
\usage{
esFinal(esDf, RELEVANTINFO_ES = NULL, RELEVANTVN_ES = NULL,
  maxRows = NULL)
}
\arguments{
\item{esDf}{a data.frame. A single ESM dataset. It must contain the 2 columns that hold the date-time object for when an ESM questionnaire was started and finished, respectively.}

\item{RELEVANTINFO_ES}{a list. This list is generated by function \code{\link{setES}}.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}

\item{maxRows}{a numeric value. The number of data lines (per participant)  in the final event sampling dataset; must be equal for all participants. If no number is entered the maximum number across all participants is used.}
}
\value{
\code{esDf} with empty rows of data added and with 2 additional columns MISSED and FILLER. MISSED refers to questionnaires that should have been answered by the participants but weren't. FILLER refers to empty rows of data in order for all participants to have equally many rows of data. See \strong{Details} for more information.
}
\description{
esFinal generates the final ESM dataset.
}
\details{
The empty rows will either denote ESM questionnaires that were missed by the participant or it will denote fillers, i.e. rows of empty data to fill up the number of rows to be equal across all participants The number of maximum rows per participant either are computed by searching the actual maximum number of questionnaires started by the participant, or by what the user defines to be the maximum number of questionnaires.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute esFinal. Start ------------------
# RELEVANTINFO_ES is delivered with the package
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
# tbsqDf is a raw ESM dataset, delivered with the package.
# Prerequisites in order to execute esFinal. End --------------------
# -------------------------------------------------------
# Run function 28 of 28; see esmprep functions' hierarchy.
# -------------------------------------------------------
# tbsqDf is the result of function 'computeTimeBetween'.
esDfFin <- esFinal(tbsqDf, RELEVANTINFO_ES, RELEVANTVN_ES)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 28 of 28).
}
