% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{esmdata_sim}
\alias{esmdata_sim}
\title{Simulated ESM Data Set}
\format{
A data frame with 4200 rows and 18 columns:
\describe{
\item{dyad}{Dyad identification number}
\item{id}{Participant identification number}
\item{role}{Role of a participant within a dyad (make the partner distinguishable)}
\item{age}{Age of the participant}
\item{cond_dyad}{Treatment condition to which the dyad was assigned, as follows: 0=control group and 1=experimental group}
\item{obsno}{ESM questionnaire (beep) number of the observation that indicates their serial order}
\item{scheduled}{Timestamps (e.g., “2023/04/14 10:23:47”) of when the ESM questionnaire was scheduled}
\item{sent}{Timestamps (e.g., “2023/04/14 10:23:47”) of when the ESM questionnaire was sent}
\item{start}{Timestamps (e.g., “2023/04/14 10:23:47”) of when the ESM questionnaire was opened by the participant}
\item{end}{Timestamps (e.g., “2023/04/14 10:23:47”) of when the ESM questionnaire was item ended by the participant}
\item{PA1}{A positive affect (PA) item with a slider scale (1-100)}
\item{PA2}{A positive affect (PA) item with a slider scale (1-100)}
\item{PA3}{A positive affect (PA) item with a slider scale (1-100)}
\item{NA1}{A negative affect (NA) item with a slider scale (1-100)}
\item{NA2}{A negative affect (NA) item with a slider scale (1-100)}
\item{NA3}{A negative affect (NA) item with a slider scale (1-100)}
\item{location}{Categorical item with 4 possible answers (home, work, public space, other)}
\item{contact}{Dichotomous item (1=contact, 0=no contact)}
}
}
\usage{
esmdata_sim
}
\description{
Mimic the structure of a dataset from a heterosexual romantic couples study (i.e., ESM dyadic design).
This simulated study focuses on the emotional affect dynamics of romantic partners taking into account
the context (location and contact with the partner). In addition, this study assumes that couples are
randomized into two treatments. Thus, the dataset includes a baseline phase and a treatment phase,
where couples are randomly allocated to one of the two treatments. Here are the general characteristics
of the dataset.
More information on: \url{https://preprocess.esmtools.com/terminology.html/}
}
\keyword{datasets}
