% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esquisse-ui.R, R/esquisse-server.R
\name{esquisse-module}
\alias{esquisse-module}
\alias{esquisse_ui}
\alias{esquisse_server}
\alias{esquisseContainer}
\title{Esquisse module}
\usage{
esquisse_ui(
  id,
  header = TRUE,
  container = esquisseContainer(),
  controls = c("labs", "parameters", "appearance", "filters", "code"),
  insert_code = FALSE
)

esquisse_server(
  id,
  data_rv = NULL,
  default_aes = c("fill", "color", "size", "group", "facet"),
  import_from = c("env", "file", "copypaste", "googlesheets")
)

esquisseContainer(width = "100\%", height = "700px", fixed = FALSE)
}
\arguments{
\item{id}{Module ID.}

\item{header}{Logical. Display or not \code{esquisse} header.}

\item{container}{Container in which display the addin,
default is to use \code{esquisseContainer}, see examples.
Use \code{NULL} for no container (behavior in versions <= 0.2.1).
Must be a \code{function}.}

\item{controls}{Controls menu to be displayed. Use \code{NULL} to hide all menus.}

\item{insert_code}{Logical, Display or not a button to insert the ggplot
code in the current user script (work only in RStudio).}

\item{data_rv}{A \code{reactiveValues} with at least a slot \code{data} containing a \code{data.frame}
to use in the module. And a slot \code{name} corresponding to the name of the \code{data.frame}.}

\item{default_aes}{Default aesthetics to be used, can be a \code{character}
vector or \code{reactive} function returning one.}

\item{import_from}{From where to import data, argument passed
to \code{\link[datamods:import-modal]{datamods::import_ui}}.}

\item{width, height}{The width and height of the container, e.g. \code{"400px"},
or \code{"100\%"}; see \code{\link[htmltools]{validateCssUnit}}.}

\item{fixed}{Use a fixed container, e.g. to use use esquisse full page.
If \code{TRUE}, width and height are ignored. Default to \code{FALSE}.
It's possible to use a vector of CSS unit of length 4 to specify the margins
(top, right, bottom, left).}
}
\value{
A \code{reactiveValues} with 3 slots :
\itemize{
\item \strong{code_plot} : code to generate plot.
\item \strong{code_filters} : a list of length two with code to reproduce filters.
\item \strong{data} : \code{data.frame} used in plot (with filters applied).
}
}
\description{
Use esquisse as a module in a Shiny application.
}
\examples{

### Part of a Shiny app ###

library(shiny)
library(esquisse)

ui <- fluidPage(
  tags$h1("Use esquisse as a Shiny module"),
  
  radioButtons(
    inputId = "data", 
    label = "Data to use:", 
    choices = c("iris", "mtcars"),
    inline = TRUE
  ),
  checkboxGroupInput(
    inputId = "aes", 
    label = "Aesthetics to use:", 
    choices = c(
      "fill", "color", "size", "shape", 
      "weight", "group", "facet", "facet_row", "facet_col"
    ),
    selected = c("fill", "color", "size", "facet"),
    inline = TRUE
  ),
  esquisse_ui(
    id = "esquisse", 
    header = FALSE, # dont display gadget title
    container = esquisseContainer(height = "700px")
  )
)

server <- function(input, output, session) {
  
  data_rv <- reactiveValues(data = iris, name = "iris")
  
  observeEvent(input$data, {
    if (input$data == "iris") {
      data_rv$data <- iris
      data_rv$name <- "iris"
    } else {
      data_rv$data <- mtcars
      data_rv$name <- "mtcars"
    }
  })
  
  esquisse_server(
    id = "esquisse", 
    data_rv = data_rv, 
    default_aes = reactive(input$aes)
  )
  
}

if (interactive())
  shinyApp(ui, server)


### Whole Shiny app ###

library(shiny)
library(esquisse)


# Load some datasets in app environment
my_data <- data.frame(
  var1 = rnorm(100),
  var2 = sample(letters[1:5], 100, TRUE)
)


ui <- fluidPage(
  esquisse_ui(
    id = "esquisse", 
    container = esquisseContainer(fixed = TRUE)
  )
)

server <- function(input, output, session) {
  
  esquisse_server(id = "esquisse")
  
}

if (interactive())
  shinyApp(ui, server)



## You can also use a vector of margins for the fixed argument,
# useful if you have a navbar for example

library(shiny)
library(esquisse)
library(datamods)

ui <- navbarPage(
  title = "My navbar app",
  tabPanel(
    title = "esquisse",
    esquisse_ui(
      id = "esquisse", 
      header = FALSE,
      container = esquisseContainer(
        fixed = c(55, 0, 0, 0)
      )
    )
  )
)

server <- function(input, output, session) {
  
  # lauch import data modal
  import_modal(
    id = "import-data",
    from = c("env", "file", "copypaste"),
    title = "Import data"
  )
  data_imported_r <- datamods::import_server("import-data")

  data_rv <- reactiveValues(data = data.frame())
  observeEvent(data_imported_r$data(), {
    data_rv$data <- data_imported_r$data()
    data_rv$name <- data_imported_r$name()
  })
  
  esquisse_server(id = "esquisse", data_rv = data_rv)
  
}

if (interactive())
  shinyApp(ui, server)
}
