% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabla.bidimensional.R
\name{tabla.bidimensional}
\alias{tabla.bidimensional}
\title{Tabla doble entrada.}
\usage{
tabla.bidimensional(x,
             distribucion = c("cruzada","condicionada"),
             frecuencias = c("absolutas","relativas"),
             exportar = FALSE)
}
\arguments{
\item{x}{Conjunto de datos. Tiene que ser un dataframe (al menos dos variables, es decir, dos columnas).}

\item{distribucion}{Es un caracter. Por defecto se obtien la tabla cruzada (\code{distribucion = "cruzada"}). Para obtener las distribuciones condicionadas cambiar a \code{distribucion = "condicionada"}.}

\item{frecuencias}{Es un carácter. Por defecto se obtienen las frecuencias absolutas ordinarias (\code{frecuencias = "absolutas"}). Para obtener las frecuencias relativas ordinarias cambiar a \code{frecuencias = "relativas"}.}

\item{exportar}{Para exportar los resultados a una hoja de cálculo Excel (\code{exportar = TRUE}).}
}
\value{
Devuelve la tabla cruzada de las dos variables seleccionadas en un \code{data.frame}
}
\description{
Calcula la tabla de frecuencias bidimensionales.
}
\references{
Esteban García, J. y otros. (2005). Estadística descriptiva y nociones de probabilidad. Paraninfo. ISBN: 9788497323741

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

\strong{Cristina Pardo-García}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
